/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.park.remote.ParkParkingMeterRemote;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingLotService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingMeterService;
import com.zkteco.zkbiosecurity.park.vo.ParkParkingMeterItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkParkingMeterController
extends ExportController
implements ParkParkingMeterRemote {
    @Autowired
    private ParkParkingMeterService parkParkingMeterService;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ParkParkingLotService parkParkingLotService;

    @RequiresPermissions(value={"park:parkingMeter"})
    public ModelAndView index() {
        StringBuffer showColumns = new StringBuffer("!photoPathIn,photoPathOut,dutyName");
        String isShowLotInfName = "true";
        if (!"zkteco-park".equals(this.parkParamsService.getParkingLotCommMode())) {
            isShowLotInfName = "false";
            showColumns.append(",parkingLotInfName");
        }
        this.request.setAttribute("showColumns", (Object)showColumns);
        this.request.setAttribute("isShowLotInfName", (Object)isShowLotInfName);
        return new ModelAndView("park/parkingMeter/parkParkingMeter");
    }

    @RequiresPermissions(value={"park:parkingMeter:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkParkingMeterService.getItemById(id));
        }
        return new ModelAndView("park/parkingMeter/editParkParkingMeter");
    }

    @RequiresPermissions(value={"park:parkingMeter:edit"})
    public ZKResultMsg save(ParkParkingMeterItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.parkParkingMeterService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(ParkParkingMeterItem codition) {
        String parkingLotIds = this.parkParkingLotService.getParkingLotIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)parkingLotIds)) {
            codition.setParkingLotInfIdIn(parkingLotIds);
        }
        Pager pager = this.parkParkingMeterService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkParkingMeterService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @LogRequest(module="park_module", object="park_leftMenu_chargeDetail", opType="common_op_export", opContent="common_op_export")
    @RequiresPermissions(value={"park:parkingMeter:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        ParkParkingMeterItem parkParkingMeterItem = new ParkParkingMeterItem();
        String parkingLotIds = this.parkParkingLotService.getParkingLotIdsByAuthFilter(request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)parkingLotIds)) {
            parkParkingMeterItem.setParkingLotInfIdIn(parkingLotIds);
        }
        this.setConditionValue((BaseItem)parkParkingMeterItem);
        List itemList = this.parkParkingMeterService.getItemData(parkParkingMeterItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, ParkParkingMeterItem.class);
    }

    public ZKResultMsg getPhotoByMeterId(String meterId, String columnName) {
        String photo = this.parkParkingMeterService.getPhotoByMeterId(meterId, columnName);
        return new ZKResultMsg((Object)photo);
    }
}

