/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.auth.service.AuthSessionServcie;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.park.enums.ParkingLotTypeEnum;
import com.zkteco.zkbiosecurity.park.remote.ParkParkingLotRemote;
import com.zkteco.zkbiosecurity.park.service.ParkParkingLotService;
import com.zkteco.zkbiosecurity.park.vo.ParkParkingLotItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkParkingLotController
extends BaseController
implements ParkParkingLotRemote {
    @Autowired
    private ParkParkingLotService parkParkingLotService;
    @Autowired(required=false)
    private AuthSessionServcie authSessionServcie;

    @RequiresPermissions(value={"park:parkingLot"})
    public ModelAndView index() {
        StringBuffer showColumns = new StringBuffer("!address");
        this.request.setAttribute("showColumns", (Object)showColumns);
        return new ModelAndView("park/parkingLot/parkParkingLot");
    }

    @RequiresPermissions(value={"park:parkingLot:add"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkParkingLotService.getItemById(id));
        }
        return new ModelAndView("park/parkingLot/editParkParkingLot");
    }

    @RequiresPermissions(value={"park:parkingLot:edit"})
    @LogRequest(module="park_module", object="park_leftMenu_parkingLot", opType="park_parkingLot_edit", requestParams={"names"}, opContent="park_parkingLotSet_parkParkingName")
    public ZKResultMsg save(ParkParkingLotItem item) {
        this.parkParkingLotService.saveItem(item);
        this.parkParkingLotService.setParkingLotInfoToCache(item);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"park:parkingLot:refresh"})
    public DxGrid list(ParkParkingLotItem codition) {
        SecuritySubject authUser = this.authSessionServcie.getSecuritySubject(this.request.getSession().getId());
        if (!authUser.getIsSuperuser().booleanValue() && CollectionUtils.isNotEmpty((Collection)authUser.getDepartmentIds())) {
            codition.setDeptIdIn(StrUtil.collectionToStr((Collection)authUser.getDepartmentIds()));
        }
        Pager pager = this.parkParkingLotService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"park:parkingLot:del"})
    @LogRequest(module="park_module", object="park_leftMenu_parkingLot", opType="park_parkingLot_del", requestParams={"names"}, opContent="park_parkingLotSet_parkParkingName")
    public ZKResultMsg delete(String ids) {
        ZKResultMsg res = new ZKResultMsg();
        this.parkParkingLotService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public boolean isNotExist(@RequestParam(value="name", required=false) String name) {
        return this.parkParkingLotService.isNotExist(name);
    }

    public boolean isNotExistParkCode(@RequestParam(value="parkCode", required=false) String parkCode) {
        return this.parkParkingLotService.isNotExistParkCode(parkCode);
    }

    public boolean isNotExistParkParkingArea(@RequestParam(value="parkingLotInfId", required=false) String parkingLotInfId) {
        return this.parkParkingLotService.isNotExistParkParkingArea(parkingLotInfId);
    }

    public ZKResultMsg getAllParkingLot() {
        List<String> parkingLotInfIds = new ArrayList();
        SecuritySubject authUser = this.authSessionServcie.getSecuritySubject(this.request.getSession().getId());
        if (!authUser.getIsSuperuser().booleanValue() && CollectionUtils.isNotEmpty((Collection)authUser.getDepartmentIds()) && CollectionUtils.isEmpty(parkingLotInfIds = this.parkParkingLotService.loginAuthfilter(StrUtil.collectionToStr((Collection)authUser.getDepartmentIds())))) {
            parkingLotInfIds.add("-1");
        }
        List selectItems = this.parkParkingLotService.getAllParkingLot(parkingLotInfIds);
        return new ZKResultMsg((Object)selectItems);
    }

    public ZKResultMsg saveDeviceAuthDept(@RequestParam(value="deviceIds", required=false) String deviceIds, @RequestParam(value="parkingLotInfId", required=false) String parkingLotInfId) {
        this.parkParkingLotService.saveDeviceAuthDept(deviceIds, parkingLotInfId);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg isNotExistDeviceChannel(@RequestParam(value="deviceIds", required=false) String deviceIds) {
        return new ZKResultMsg((Object)this.parkParkingLotService.isNotExistDeviceChannel(deviceIds));
    }

    @RequiresPermissions(value={"park:device:changeParkingLot", "park:blackWhite:changeParkingLot", "park:parkingArea:changeParkingLot"})
    public ZKResultMsg saveBatchAuthParkingLot(@RequestParam(value="dataIds", required=false) String dataIds, @RequestParam(value="batchType", required=false) String batchType, @RequestParam(value="parkingLotInfId", required=false) String parkingLotInfId) {
        this.parkParkingLotService.saveBatchAuthParkingLot(dataIds, batchType, parkingLotInfId);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"park:device:changeParkingLot", "park:blackWhite:changeParkingLot", "park:parkingArea:changeParkingLot"})
    public ZKResultMsg isNotExistParkingLot(@RequestParam(value="dataIds", required=false) String dataIds, @RequestParam(value="batchType", required=false) String batchType) {
        String notExistCheckedData = this.parkParkingLotService.isNotExistCheckedData(dataIds, batchType);
        return new ZKResultMsg((Object)notExistCheckedData);
    }

    public boolean isNotExistParkEntranceArea(@RequestParam(value="parkingAreaId", required=false) String parkingAreaId) {
        return this.parkParkingLotService.isNotExistParkEntranceArea(parkingAreaId);
    }

    public ZKResultMsg getParkingLotTypeSelectItem() {
        List selectItems = ParkingLotTypeEnum.getParkingLotTypeSelectItem();
        return new ZKResultMsg((Object)selectItems);
    }

    public ZKResultMsg getParkingLotFilter(String filter) {
        return null;
    }
}

