/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.remote.ParkParkingAreaRemote;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingAreaService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingLotService;
import com.zkteco.zkbiosecurity.park.service.ParkPavilioService;
import com.zkteco.zkbiosecurity.park.vo.ParkParkingAreaItem;
import com.zkteco.zkbiosecurity.park.vo.ParkPavilioItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkParkingAreaController
extends BaseController
implements ParkParkingAreaRemote {
    @Autowired
    private ParkParkingAreaService parkParkingAreaService;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ParkPavilioService parkPavilioService;
    @Autowired
    private ParkParkingLotService parkParkingLotService;

    @RequiresPermissions(value={"park:parkingArea"})
    public ModelAndView index() {
        String isShowZkParking = "true";
        if (!"zkteco-park".equals(this.parkParamsService.getParkingLotCommMode())) {
            this.request.setAttribute("showColumns", (Object)"!parkingLotInfName,areaCode");
            isShowZkParking = "false";
        }
        this.request.setAttribute("isShowZkParking", (Object)isShowZkParking);
        if (this.parkParamsService.isDisplayParkingSpace()) {
            return new ModelAndView("park/parkingArea/parkParkingArea");
        }
        return new ModelAndView("park/parkingArea/parkParkingAreaNoSpace");
    }

    @RequiresPermissions(value={"park:parkingArea:add"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkParkingAreaService.getItemById(id));
        }
        if (this.parkParamsService.isDisplayParkingSpace()) {
            return new ModelAndView("park/parkingArea/editParkParkingArea");
        }
        String isShowLotInfName = "false";
        if ("zkteco-park".equals(this.parkParamsService.getParkingLotCommMode())) {
            isShowLotInfName = "true";
        }
        this.request.setAttribute("isShowLotInfName", (Object)isShowLotInfName);
        return new ModelAndView("park/parkingArea/editParkParkingAreaNoSpace");
    }

    @RequiresPermissions(value={"park:parkingArea:edit"})
    @LogRequest(module="park_module", object="park_parkingArea", opType="park_parkingArea_edit", requestParams={"name"}, opContent="park_parkingArea_name")
    public ZKResultMsg save(ParkParkingAreaItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.parkParkingAreaService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"park:parkingArea:refresh"})
    public DxGrid list(ParkParkingAreaItem codition) {
        String parkingLotIds = this.parkParkingLotService.getParkingLotIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)parkingLotIds)) {
            codition.setParkingLotInfIdIn(parkingLotIds);
        }
        Pager pager = this.parkParkingAreaService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"park:parkingArea:del"})
    @LogRequest(module="park_module", object="park_parkingArea", opType="park_parkingArea_del", requestParams={"names"}, opContent="park_parkingArea_name")
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkParkingAreaService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getAllBigParkingArea() {
        List selectItems = this.parkParkingAreaService.getAllBigParkingArea();
        return new ZKResultMsg((Object)selectItems);
    }

    public ZKResultMsg getAllParkingArea() {
        String parkingLotIds = this.parkParkingLotService.getParkingLotIdsByAuthFilter(this.request.getSession().getId());
        List selectItems = StringUtils.isBlank((CharSequence)parkingLotIds) ? this.parkParkingAreaService.getAllParkingArea() : this.parkParkingAreaService.getAllParkingAreaList(parkingLotIds);
        return new ZKResultMsg((Object)selectItems);
    }

    public boolean isNotExist(@RequestParam(value="name", required=false) String name) {
        return this.parkParkingAreaService.isNotExist(name);
    }

    @RequiresPermissions(value={"park:parkingSpace:add"})
    public ModelAndView addParkingSpace(@RequestParam(value="id") String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("parkingAreaId", (Object)id);
            this.request.setAttribute("parkingAreaName", (Object)this.parkParkingAreaService.getNameById(id));
        }
        return new ModelAndView("park/parkingSpace/editParkParkingSpace");
    }

    public ZKResultMsg isBigAreaByPavilioId(@RequestParam(value="pavilioId") String pavilioId) {
        boolean isBigArea = this.parkParkingAreaService.isBigAreaByPavilioId(pavilioId);
        ParkPavilioItem parkPavilioItem = this.parkPavilioService.getItemById(pavilioId);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("isBigArea", isBigArea);
        map.put("isWebClient", ParkConstants.PAVILIO_WEB.equals(parkPavilioItem.getClientMode()));
        return new ZKResultMsg(map);
    }
}

