/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.park.remote.ParkOffineSetRemote;
import com.zkteco.zkbiosecurity.park.service.ParkDeviceService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.vo.ParkDeviceItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkOffineSetController
extends BaseController
implements ParkOffineSetRemote {
    @Autowired
    ParkDeviceService parkDeviceService;
    @Autowired
    private ParkParamsService parkParamsService;

    @RequiresPermissions(value={"park:offineSet"})
    public ModelAndView index() {
        String isShowAdd = "true";
        List items = this.parkDeviceService.findAll();
        List parkDeviceItemList = items.stream().sorted(Comparator.comparing(ParkDeviceItem::getName)).collect(Collectors.toList());
        if ("best-w".equals(this.parkParamsService.getParkingLotCommMode())) {
            isShowAdd = "false";
        }
        this.request.setAttribute("isShowAdd", (Object)isShowAdd);
        ModelAndView modelAndView = new ModelAndView("park/offineSet/parkOfflineSet");
        modelAndView.addObject("parkChannelItemList", parkDeviceItemList);
        return modelAndView;
    }
}

