/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.remote.ParkMessageTemplateRemote;
import com.zkteco.zkbiosecurity.park.service.ParkMessageNotifyService;
import com.zkteco.zkbiosecurity.park.service.ParkMessageTemplateService;
import com.zkteco.zkbiosecurity.park.vo.ParkMessageTemplateItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ParkMessageTemplateController
implements ParkMessageTemplateRemote {
    @Autowired
    private ParkMessageNotifyService parkMessageNotifyService;
    @Autowired
    private ParkMessageTemplateService parkMessageTemplateService;

    @LogRequest(module="park_module", object="park_carDelay", opType="park_message_sendMsg", requestParams={"names"}, opContent="park_message_sendMsg")
    @RequiresPermissions(value={"park:authorizeDelay:sendMsg"})
    public ZKResultMsg sendMessage(ParkMessageTemplateItem item) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{item.getSubject(), item.getContent()})) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
        }
        if ("send".equals(item.getOpMode())) {
            this.parkMessageTemplateService.parkMsgNotify(item);
        }
        this.parkMessageTemplateService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isNotExistSendType(@RequestParam(value="sendType") String sendType) {
        boolean boo = false;
        if ("1".equals(sendType)) {
            boo = this.parkMessageNotifyService.checkMailInfo();
        } else if ("2".equals(sendType)) {
            boo = this.parkMessageNotifyService.checkSMSInfo();
        } else if ("3".equals(sendType)) {
            boo = this.parkMessageNotifyService.checkWhatsappInfo();
        }
        return boo;
    }

    public ZKResultMsg initData(@RequestParam(value="templateSort") String templateSort) {
        ZKResultMsg res = new ZKResultMsg();
        res.setData((Object)this.parkMessageTemplateService.initData(templateSort));
        return res;
    }

    public boolean isNotExistName(@RequestParam(value="templateName") String templateName) {
        return this.parkMessageTemplateService.isNotExistName(templateName);
    }
}

