/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.park.remote.ParkLevelRecordRemote;
import com.zkteco.zkbiosecurity.park.service.ParkLevelRecordService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingLotService;
import com.zkteco.zkbiosecurity.park.vo.ParkLevelRecordItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkLevelRecordController
extends ExportController
implements ParkLevelRecordRemote {
    @Autowired
    private ParkLevelRecordService parkLevelRecordService;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ParkParkingLotService parkParkingLotService;

    @RequiresPermissions(value={"park:levelRecord"})
    public ModelAndView index() {
        StringBuffer hideColumns = new StringBuffer("!");
        if (!this.parkParamsService.isDisplayParkingSpace()) {
            hideColumns.append("parkingSpaceName,");
        }
        if (this.parkParamsService.isLprCamera()) {
            hideColumns.append("cardNumber,");
        }
        if ("many".equals(this.parkParamsService.getParkingLotModel())) {
            hideColumns.append("carNumber");
        }
        this.request.setAttribute("showColumns", (Object)hideColumns.toString());
        return new ModelAndView("park/levelRecord/parkLevelRecord");
    }

    public DxGrid list(ParkLevelRecordItem codition) {
        String parkingLotIds = this.parkParkingLotService.getParkingLotIdsByAuthFilter(this.request.getSession().getId());
        Pager pager = this.parkLevelRecordService.getItemsByPageList((BaseItem)codition, this.getPageNo(), this.getPageSize(), this.getLimitCount(), parkingLotIds);
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="park_module", object="park_leftMenu_authReport", opType="common_op_export", opContent="common_op_export")
    @RequiresPermissions(value={"park:levelRecord:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        ParkLevelRecordItem parkLevelRecordItem = new ParkLevelRecordItem();
        this.setConditionValue((BaseItem)parkLevelRecordItem);
        List itemList = this.parkLevelRecordService.getItemData(parkLevelRecordItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, ParkLevelRecordItem.class);
    }
}

