/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.bean.ParkCheckOutInfo;
import com.zkteco.zkbiosecurity.park.remote.ParkDoubleVerifyParamsRemote;
import com.zkteco.zkbiosecurity.park.service.ParkDoubleVerifyParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordoutService;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkDoubleVerifyParamsController
extends BaseController
implements ParkDoubleVerifyParamsRemote {
    @Autowired
    private ParkDoubleVerifyParamsService parkDoubleVerifyParamsService;
    @Autowired
    private ParkRecordinService parkRecordinService;
    @Autowired
    private ParkRecordoutService parkRecordoutService;

    @RequiresPermissions(value={"park:doubleVerifyParams"})
    public ModelAndView index() {
        Map parkParams = this.parkDoubleVerifyParamsService.getDoubleCheckParkParams();
        this.request.setAttribute("parkParams", (Object)parkParams);
        return new ModelAndView("park/doubleVerifyParams/parkDoubleVerifyParams");
    }

    @RequiresPermissions(value={"park:doubleVerifyParams:edit"})
    public ZKResultMsg save(Map<String, String> params) {
        ZKResultMsg res = new ZKResultMsg();
        this.parkDoubleVerifyParamsService.saveItem(params);
        return res;
    }

    public ZKResultMsg validationFailedInConfirm(ParkCheckOutInfo parkCheckOutInfo) {
        this.parkRecordinService.confirmIn(parkCheckOutInfo);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg validationFailedOutConfirm(ParkCheckOutInfo parkCheckOutInfo) {
        this.parkRecordoutService.fixCheckoutConfirm(parkCheckOutInfo);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg validationFailedOutClose(boolean validationFailed, String channelId, String parkingMeterId, String validationFailedName) {
        this.parkDoubleVerifyParamsService.validationFailedOutClose(validationFailed, channelId, parkingMeterId, validationFailedName);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg validationFailedInClose(boolean validationFailed, String channelId, String license, String validationFailedName) {
        this.parkDoubleVerifyParamsService.transactionRecord(validationFailed, channelId, license, null, validationFailedName);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

