/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.remote.ParkDoubleVerifyAccDeviceRemote;
import com.zkteco.zkbiosecurity.park.service.ParkDoubleVerifyAccDeviceService;
import com.zkteco.zkbiosecurity.park.vo.ParkDoubleVerifyAccDeviceItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkDoubleVerifyAccDeviceController
extends BaseController
implements ParkDoubleVerifyAccDeviceRemote {
    @Autowired
    private ParkDoubleVerifyAccDeviceService parkDoubleVerifyAccDeviceService;

    @RequiresPermissions(value={"park:doubleVerifyAccDevice"})
    public ModelAndView index() {
        return new ModelAndView("park/doubleVerifyDevice/parkDoubleVerifyAccDevice");
    }

    @RequiresPermissions(value={"park:doubleVerifyAccDevice:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkDoubleVerifyAccDeviceService.getItemById(id));
        }
        return new ModelAndView("park/doubleVerifyDevice/editParkDoubleVerifyAccDevice");
    }

    @RequiresPermissions(value={"park:doubleVerifyAccDevice:add"})
    @LogRequest(module="park_module", object="park_leftMenu_doubleVerify_AccDevice", opType="common_op_edit", requestParams={"name"}, opContent="park_doubleVerify_boundName")
    public ZKResultMsg save(ParkDoubleVerifyAccDeviceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.parkDoubleVerifyAccDeviceService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"park:doubleVerifyAccDevice:refresh"})
    public DxGrid list(ParkDoubleVerifyAccDeviceItem codition) {
        Pager pager = this.parkDoubleVerifyAccDeviceService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"park:doubleVerifyAccDevice:del"})
    @LogRequest(module="park_module", object="park_leftMenu_doubleVerify_AccDevice", opType="common_op_del", requestParams={"names"}, opContent="park_doubleVerify_boundName")
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkDoubleVerifyAccDeviceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getCount() {
        return new ZKResultMsg((Object)this.parkDoubleVerifyAccDeviceService.getCount());
    }

    public boolean isNotExist(@RequestParam(value="name", required=false) String name) {
        return this.parkDoubleVerifyAccDeviceService.isNotExist(name);
    }

    @RequiresPermissions(value={"park:doubleVerifyAccDevice:add"})
    public ZKResultMsg getAllDoor(@RequestParam(value="editDoorId", required=false) String editDoorId) {
        List selectItems = this.parkDoubleVerifyAccDeviceService.getAllDoor(editDoorId);
        return new ZKResultMsg((Object)selectItems);
    }

    @RequiresPermissions(value={"park:doubleVerifyAccDevice:add"})
    public ZKResultMsg getModuleDevice(@RequestParam(value="editDoorId", required=false) String editDoorId, @RequestParam(value="deviceModule") String deviceModule) {
        List selectItems = this.parkDoubleVerifyAccDeviceService.getModuleDevice(editDoorId, deviceModule);
        return new ZKResultMsg((Object)selectItems);
    }

    @RequiresPermissions(value={"park:doubleVerifyAccDevice:add"})
    public ZKResultMsg getAllChannel(@RequestParam(value="editChannelId", required=false) String editChannelId) {
        List selectItems = this.parkDoubleVerifyAccDeviceService.getAllChannel(editChannelId);
        return new ZKResultMsg((Object)selectItems);
    }
}

