/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.remote.ParkDiscountStrategyRemote;
import com.zkteco.zkbiosecurity.park.service.ParkDiscountStrategyService;
import com.zkteco.zkbiosecurity.park.vo.ParkDiscountStrategyItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkDiscountStrategyController
extends BaseController
implements ParkDiscountStrategyRemote {
    @Autowired
    private ParkDiscountStrategyService parkDiscountStrategyService;

    @RequiresPermissions(value={"park:discountStrategy"})
    public ModelAndView index() {
        return new ModelAndView("park/discountStrategy/parkDiscountStrategy");
    }

    @RequiresPermissions(value={"park:discountStrategy:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkDiscountStrategyService.getItemById(id));
        }
        return new ModelAndView("park/discountStrategy/editParkDiscountStrategy");
    }

    @RequiresPermissions(value={"park:discountStrategy:edit"})
    @LogRequest(module="park_module", object="park_discountStrategy", opType="park_discountStrategy_edit", requestParams={"name"}, opContent="park_discountStrategy_name")
    public ZKResultMsg save(ParkDiscountStrategyItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.parkDiscountStrategyService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"park:discountStrategy:refresh"})
    public DxGrid list(ParkDiscountStrategyItem codition) {
        Pager pager = this.parkDiscountStrategyService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="park_module", object="park_discountStrategy", opType="park_discountStrategy_del", requestParams={"names"}, opContent="park_discountStrategy_del")
    @RequiresPermissions(value={"park:discountStrategy:del"})
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkDiscountStrategyService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isNotExist(@RequestParam(value="name", required=false) String name) {
        return this.parkDiscountStrategyService.isNotExist(name);
    }

    public TreeItem tree() {
        return this.parkDiscountStrategyService.tree();
    }

    public ZKResultMsg getByShopId(@RequestParam(value="shopId") String shopId) {
        List selectItems = this.parkDiscountStrategyService.getByShopId(shopId);
        return new ZKResultMsg((Object)selectItems);
    }
}

