/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.auth.service.AuthSessionServcie;
import com.zkteco.zkbiosecurity.auth.service.AuthUserService;
import com.zkteco.zkbiosecurity.auth.vo.AuthAppItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthAreaItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthDepartmentItem;
import com.zkteco.zkbiosecurity.auth.vo.AuthUserItem;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.park.remote.ParkChangeShiftsRemote;
import com.zkteco.zkbiosecurity.park.service.ParkChangeShiftsService;
import com.zkteco.zkbiosecurity.park.service.ParkWorkRecordService;
import com.zkteco.zkbiosecurity.park.utils.ParkGetLocalIpAddrUtil;
import com.zkteco.zkbiosecurity.park.vo.ParkChangeShiftsItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkChangeShiftsController
extends BaseController
implements ParkChangeShiftsRemote {
    @Autowired
    private ParkChangeShiftsService parkChangeShiftsService;
    @Autowired
    private ParkWorkRecordService parkWorkRecordService;
    @Autowired(required=false)
    private BaseLicenseService baseLicenseService;
    @Autowired(required=false)
    private AuthUserService authUserService;
    @Autowired(required=false)
    private AuthSessionServcie authSessionServcie;

    @RequiresPermissions(value={"park:changeShifts"})
    public ModelAndView index() {
        return new ModelAndView("park/changeShifts/parkChangeShifts");
    }

    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkChangeShiftsService.getItemById(id));
        }
        return new ModelAndView("park/changeShifts/editParkChangeShifts");
    }

    public ZKResultMsg save(ParkChangeShiftsItem item) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        try {
            zkResultMsg = this.authUserService.login(item.getUsername(), item.getPassword());
            if (zkResultMsg.getData() != null) {
                this.parkChangeShiftsService.saveItem(item);
                AuthUserItem authUser = (AuthUserItem)zkResultMsg.getData();
                if (this.baseLicenseService != null) {
                    this.baseLicenseService.checkLicensePreLogin(null, authUser.getIsSuperuser());
                }
                SecuritySubject securitySubject = new SecuritySubject(authUser.getId(), authUser.getUsername(), authUser.getName(), authUser.getIsSuperuser());
                securitySubject.setPermissions(authUser.getPermissionSet());
                securitySubject.setRoles(authUser.getRoleSet());
                securitySubject.setAreaIds(this.loadAreaIds(authUser, authUser.getAreaList()));
                securitySubject.setDepartmentIds(this.loadDepartmentIds(authUser, authUser.getDepartmentList()));
                securitySubject.setCompanyId(authUser.getCompanyId());
                securitySubject.setAppIds(this.loadAppIds(authUser, authUser.getAppList()));
                this.request.getSession().setAttribute("user", (Object)securitySubject);
                this.parkWorkRecordService.dutyLoginUpdateWork(ParkGetLocalIpAddrUtil.getClientIpAddr(this.request), authUser.getId(), authUser.getUsername());
            }
        }
        catch (ZKBusinessException e) {
            this.log.error("login error", (Throwable)e);
            zkResultMsg = ZKResultMsg.getFailMsg((String)e.getMessage());
        }
        catch (Exception e) {
            this.log.error("login error", (Throwable)e);
            zkResultMsg = ZKResultMsg.getFailMsg((String)"auth_login_exception");
        }
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    private Set<String> loadAreaIds(AuthUserItem authUser, List<AuthAreaItem> areas) {
        HashSet<String> ids = new HashSet<String>();
        for (AuthAreaItem item : areas) {
            ids.add(item.getId());
        }
        if (!authUser.getIsSuperuser().booleanValue()) {
            ids.add("-1");
        }
        return ids;
    }

    private Set<String> loadAppIds(AuthUserItem authUser, List<AuthAppItem> apps) {
        HashSet<String> ids = new HashSet<String>();
        for (AuthAppItem item : apps) {
            ids.add(item.getId());
        }
        if (!authUser.getIsSuperuser().booleanValue()) {
            ids.add("-1");
        }
        return ids;
    }

    private Set<String> loadDepartmentIds(AuthUserItem authUser, List<AuthDepartmentItem> departments) {
        HashSet<String> ids = new HashSet<String>();
        for (AuthDepartmentItem item : departments) {
            ids.add(item.getId());
        }
        if (!authUser.getIsSuperuser().booleanValue()) {
            ids.add("-1");
        }
        return ids;
    }

    public DxGrid list(ParkChangeShiftsItem codition) {
        Pager pager = this.parkChangeShiftsService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkChangeShiftsService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ModelAndView checkFinancialStatement(@RequestParam(value="id") String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            SecuritySubject authUser = this.authSessionServcie.getSecuritySubject(this.request.getSession().getId());
            this.request.setAttribute("item", (Object)this.parkChangeShiftsService.getItemById(id, authUser));
        }
        return new ModelAndView("park/financialStatements/editParkFinancialStatements");
    }

    public ZKResultMsg checkConfirmState(@RequestParam(value="id") String id) {
        ZKResultMsg res = new ZKResultMsg((Object)true);
        ParkChangeShiftsItem parkChangeShiftsItem = this.parkChangeShiftsService.getItemById(id);
        if (StringUtils.isNotBlank((CharSequence)parkChangeShiftsItem.getFinancialStatementsId())) {
            res.setData((Object)false);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg getCurrPavilioShiftsInfo() {
        ParkChangeShiftsItem parkChangeShiftsItem = this.parkChangeShiftsService.getCurrPavilioShiftsInfo(ParkGetLocalIpAddrUtil.getClientIpAddr(this.request), this.request.getSession().getId());
        return new ZKResultMsg((Object)parkChangeShiftsItem);
    }

    public ModelAndView getShiftsInfoToShift() {
        ParkChangeShiftsItem parkChangeShiftsItem = this.parkChangeShiftsService.getCurrPavilioShiftsInfo(ParkGetLocalIpAddrUtil.getClientIpAddr(this.request), this.request.getSession().getId());
        this.request.setAttribute("parkChangeShiftsItem", (Object)parkChangeShiftsItem);
        return new ModelAndView("park/terminalManage/opParkChangeShifts");
    }
}

