/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.park.remote.ParkBlackWhiteRemote;
import com.zkteco.zkbiosecurity.park.service.ParkBlackWhiteService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingLotService;
import com.zkteco.zkbiosecurity.park.vo.ParkBlackWhiteItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkBlackWhiteController
extends BaseController
implements ParkBlackWhiteRemote {
    @Autowired
    private ParkBlackWhiteService parkBlackWhiteService;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ParkParkingLotService parkParkingLotService;

    @RequiresPermissions(value={"park:blackWhite"})
    public ModelAndView index() {
        String isShowComm = "false";
        String isShowZkParking = "true";
        if (!"zkteco-park".equals(this.parkParamsService.getParkingLotCommMode())) {
            isShowComm = "true";
            isShowZkParking = "false";
            this.request.setAttribute("showColumns", (Object)"!parkingLotInfName");
        }
        this.request.setAttribute("isShowComm", (Object)isShowComm);
        this.request.setAttribute("isShowZkParking", (Object)isShowZkParking);
        return new ModelAndView("park/blackWhite/parkBlackWhite");
    }

    @RequiresPermissions(value={"park:blackWhite:add"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        ParkBlackWhiteItem item = this.parkBlackWhiteService.getItemById(id);
        this.request.setAttribute("item", (Object)item);
        String isShowLotInfName = "false";
        if ("zkteco-park".equals(this.parkParamsService.getParkingLotCommMode())) {
            isShowLotInfName = "true";
        }
        this.request.setAttribute("isShowLotInfName", (Object)isShowLotInfName);
        return new ModelAndView("park/blackWhite/editParkBlackWhite");
    }

    @RequiresPermissions(value={"park:blackWhite:edit"})
    @LogRequest(module="park_module", object="park_blackWhite", opType="park_blackWhite_edit", requestParams={"carNumber"}, opContent="park_carNumber")
    public ZKResultMsg save(ParkBlackWhiteItem item) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = (List)this.parkBlackWhiteService.saveItem(item).getData();
        res.setData((Object)parkDeviceOpRecordItemList);
        return res;
    }

    @RequiresPermissions(value={"park:blackWhite:refresh"})
    public DxGrid list(ParkBlackWhiteItem codition) {
        String parkingLotIds = this.parkParkingLotService.getParkingLotIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)parkingLotIds)) {
            codition.setParkingLotInfIdIn(parkingLotIds);
        }
        Pager pager = this.parkBlackWhiteService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"park:blackWhite:del"})
    @LogRequest(module="park_module", object="park_blackWhite", opType="park_blackWhite_del", requestParams={"names"}, opContent="park_carNumber")
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkBlackWhiteService.delByIds(ids);
        res.setData((Object)parkDeviceOpRecordItemList);
        return res;
    }

    public boolean isNotExist(@RequestParam(value="carNumber", required=false) String carNumber) {
        return this.parkBlackWhiteService.isNotExist(carNumber);
    }

    @RequiresPermissions(value={"park:blackWhite:syncBlack"})
    @LogRequest(module="park_module", object="park_blackWhite", opType="park_blackWhite_syncBlack", requestParams={}, opContent="park_blackWhite_syncBlack")
    public ZKResultMsg syncBlack() {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkBlackWhiteService.syncBlack();
        res.setData((Object)parkDeviceOpRecordItemList);
        return res;
    }

    @RequiresPermissions(value={"park:blackWhite:syncWhite"})
    @LogRequest(module="park_module", object="park_blackWhite", opType="park_blackWhite_syncWhite", requestParams={}, opContent="park_blackWhite_syncWhite")
    public ZKResultMsg syncWhite() {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceOpRecordItemList = this.parkBlackWhiteService.syncWhite();
        res.setData((Object)parkDeviceOpRecordItemList);
        return res;
    }
}

