/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.auth.service.AuthSessionServcie;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.park.constants.ParkConstants;
import com.zkteco.zkbiosecurity.park.remote.ParkAuthorizeDelayRemote;
import com.zkteco.zkbiosecurity.park.service.ParkAuthorizeDelayService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkWebsocketService;
import com.zkteco.zkbiosecurity.park.utils.ParkI18nUtil;
import com.zkteco.zkbiosecurity.park.vo.ParkAuthorizeDelayItem;
import com.zkteco.zkbiosecurity.park.vo.ParkDeviceOpRecordItem;
import com.zkteco.zkbiosecurity.park.vo.ParkSelectAuthorizeDelayItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkAuthorizeDelayController
extends BaseController
implements ParkAuthorizeDelayRemote {
    @Autowired
    private ParkAuthorizeDelayService parkAuthorizeDelayService;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ParkWebsocketService parkWebsocketService;
    @Autowired(required=false)
    private AuthSessionServcie authSessionServcie;

    @RequestMapping
    @RequiresPermissions(value={"park:authorizeDelay"})
    public ModelAndView index() {
        StringBuffer showColumns = new StringBuffer("!");
        if (!this.parkParamsService.isDisplayParkingSpace()) {
            showColumns.append("parkingSpaceName,");
        }
        if (this.parkParamsService.isLprCamera() && this.parkParamsService.isChineseLanguage()) {
            showColumns.append("cardNo,");
        }
        this.request.setAttribute("isFixedStatistical", (Object)(this.parkParamsService.isFixedFeeScale() + ""));
        this.request.setAttribute("showColumns", (Object)showColumns.toString());
        return new ModelAndView("park/authorizeDelay/parkAuthorizeDelay");
    }

    @RequiresPermissions(value={"park:authorizeDelay:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        ParkAuthorizeDelayItem parkAuthorizeDelayItem = this.parkAuthorizeDelayService.getItemById(id);
        this.request.setAttribute("item", (Object)parkAuthorizeDelayItem);
        return new ModelAndView("park/authorizeDelay/editParkAuthorizeDelay");
    }

    @LogRequest(module="park_module", object="park_carDelay", opType="park_carDelay", requestParams={"personName"}, opContent="park_carDelay")
    @RequiresPermissions(value={"park:authorizeDelay:edit"})
    public ZKResultMsg save(ParkAuthorizeDelayItem item) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceResultList = this.parkAuthorizeDelayService.saveItem(item);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceResultList));
        if (this.parkParamsService.isDisplayParkingSpace() || !this.parkParamsService.isFixedStatistical()) {
            this.parkWebsocketService.totalParkingSpaces();
        }
        return res;
    }

    @RequiresPermissions(value={"park:authorizeDelay:refresh"})
    public DxGrid list(ParkAuthorizeDelayItem codition) {
        SecuritySubject authUser;
        if (StringUtils.isNotBlank((CharSequence)codition.getLikeName()) || StringUtils.isNotBlank((CharSequence)codition.getCarNumber()) || StringUtils.isNotBlank((CharSequence)codition.getCardNo())) {
            if (StringUtils.isNotBlank((CharSequence)codition.getCarNumber()) && "many".equals(this.parkParamsService.getParkingLotModel())) {
                codition.setCarNumberEx(codition.getCarNumber());
                codition.setCarNumber(null);
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)codition.getStatusIn()) && Short.parseShort(codition.getStatusIn()) == 2) {
                codition.setStatusIn("2,3");
            }
            int fixedCarWarningDay = this.parkParamsService.getFixedCarWarningDay();
            Date delayDate = DateUtil.getDateAfter((Date)new Date(), (int)fixedCarWarningDay);
            codition.setCarTypeType(ParkConstants.CAR_TYPE_FIX);
            codition.setEndTime(delayDate);
        }
        if (!(authUser = this.authSessionServcie.getSecuritySubject(this.request.getSession().getId())).getIsSuperuser().booleanValue() && CollectionUtils.isNotEmpty((Collection)authUser.getDepartmentIds())) {
            codition.setDeptIdIn(StrUtil.collectionToStr((Collection)authUser.getDepartmentIds()));
        }
        Pager pager = this.parkAuthorizeDelayService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="park_module", object="park_carDelay", opType="park_authorize_del", requestParams={"names"}, opContent="park_authorize_del")
    @RequiresPermissions(value={"park:authorizeDelay:del"})
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkAuthorizeDelayService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ModelAndView batchDelay() {
        if (this.parkParamsService.isDisplayParkingSpace()) {
            return new ModelAndView("park/authorizeDelay/opParkAuthorizeDelayEx");
        }
        return new ModelAndView("park/authorizeDelay/opParkAuthorizeDelay");
    }

    public DxGrid getSelectList(ParkSelectAuthorizeDelayItem codition) {
        SecuritySubject authUser = this.authSessionServcie.getSecuritySubject(this.request.getSession().getId());
        if (!authUser.getIsSuperuser().booleanValue() && CollectionUtils.isNotEmpty((Collection)authUser.getDepartmentIds())) {
            codition.setDeptIdIn(StrUtil.collectionToStr((Collection)authUser.getDepartmentIds()));
        }
        Pager pager = this.parkAuthorizeDelayService.getSelectList(codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg saveBatchAuthorizeDelay(ParkAuthorizeDelayItem parkAuthorizeDelayItem) {
        String delayAuthIds;
        ZKResultMsg res = new ZKResultMsg();
        ArrayList parkDeviceResultList = new ArrayList();
        StringBuffer stringBuffer = new StringBuffer("");
        String batchAuthorizeSelect = parkAuthorizeDelayItem.getBatchAuthorizeSelect();
        if (StringUtils.isNotBlank((CharSequence)batchAuthorizeSelect)) {
            JSONArray selectResultArray = JSONArray.parseArray((String)batchAuthorizeSelect);
            for (int i = 0; i < selectResultArray.size(); ++i) {
                JSONObject json = selectResultArray.getJSONObject(i);
                String id = json.getString("id");
                stringBuffer.append(id).append(",");
                String parkingSpaceId = json.getString("parkingSpaceId");
                parkAuthorizeDelayItem.setId(id);
                parkAuthorizeDelayItem.setParkingSpaceId(parkingSpaceId);
                parkDeviceResultList.addAll(this.parkAuthorizeDelayService.saveItem(parkAuthorizeDelayItem));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(delayAuthIds = parkAuthorizeDelayItem.getDelayAuthIds()))) {
            for (String delayAuthId : delayAuthIds.split(",")) {
                if (stringBuffer.toString().contains(delayAuthId)) continue;
                parkAuthorizeDelayItem.setId(delayAuthId);
                parkDeviceResultList.addAll(this.parkAuthorizeDelayService.saveItem(parkAuthorizeDelayItem));
            }
        }
        HashMap<String, ParkDeviceOpRecordItem> mapFail = new HashMap<String, ParkDeviceOpRecordItem>();
        HashMap<String, ParkDeviceOpRecordItem> mapSuccess = new HashMap<String, ParkDeviceOpRecordItem>();
        for (ParkDeviceOpRecordItem parkDeviceOpRecordItem : parkDeviceResultList) {
            ParkDeviceOpRecordItem deviceOpRecordItem;
            if (parkDeviceOpRecordItem.getOpRet() < 0) {
                if (mapFail.containsKey(parkDeviceOpRecordItem.getDevIpAddress())) {
                    deviceOpRecordItem = (ParkDeviceOpRecordItem)mapFail.get(parkDeviceOpRecordItem.getDevIpAddress());
                    deviceOpRecordItem.setOpIds(deviceOpRecordItem.getOpIds() + "," + parkDeviceOpRecordItem.getOpIds());
                    deviceOpRecordItem.setOpNames(deviceOpRecordItem.getOpNames() + "," + parkDeviceOpRecordItem.getOpNames());
                    mapFail.put(parkDeviceOpRecordItem.getDevIpAddress(), deviceOpRecordItem);
                    continue;
                }
                mapFail.put(parkDeviceOpRecordItem.getDevIpAddress(), parkDeviceOpRecordItem);
                continue;
            }
            if (mapSuccess.containsKey(parkDeviceOpRecordItem.getDevIpAddress())) {
                deviceOpRecordItem = (ParkDeviceOpRecordItem)mapSuccess.get(parkDeviceOpRecordItem.getDevIpAddress());
                deviceOpRecordItem.setOpIds(deviceOpRecordItem.getOpIds() + "," + parkDeviceOpRecordItem.getOpIds());
                deviceOpRecordItem.setOpNames(deviceOpRecordItem.getOpNames() + "," + parkDeviceOpRecordItem.getOpNames());
                mapSuccess.put(parkDeviceOpRecordItem.getDevIpAddress(), deviceOpRecordItem);
                continue;
            }
            mapSuccess.put(parkDeviceOpRecordItem.getDevIpAddress(), parkDeviceOpRecordItem);
        }
        ArrayList<ParkDeviceOpRecordItem> parkDeviceOpRecordItemListEx = new ArrayList<ParkDeviceOpRecordItem>();
        mapFail.forEach((key, value) -> parkDeviceOpRecordItemListEx.add((ParkDeviceOpRecordItem)value));
        mapSuccess.forEach((key, value) -> parkDeviceOpRecordItemListEx.add((ParkDeviceOpRecordItem)value));
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceOpRecordItemListEx));
        if (this.parkParamsService.isDisplayParkingSpace() || !this.parkParamsService.isFixedStatistical()) {
            this.parkWebsocketService.totalParkingSpaces();
        }
        return res;
    }
}

