/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.auth.service.AuthSessionServcie;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.park.remote.ParkAuthorizeRemote;
import com.zkteco.zkbiosecurity.park.service.ParkAuthorizeService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkParkingLotService;
import com.zkteco.zkbiosecurity.park.service.ParkWebsocketService;
import com.zkteco.zkbiosecurity.park.vo.ParkAuthorizeItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkAuthorizeController
extends ExportController
implements ParkAuthorizeRemote {
    @Autowired
    private ParkAuthorizeService parkAuthorizeService;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private ParkWebsocketService parkWebsocketService;
    @Autowired
    private ParkParkingLotService parkParkingLotService;
    @Autowired(required=false)
    private AuthSessionServcie authSessionServcie;

    @RequiresPermissions(value={"park:authorize"})
    public ModelAndView index() {
        StringBuffer showColumns = new StringBuffer("!persMobilePhone,");
        if (!this.parkParamsService.isDisplayParkingSpace()) {
            showColumns.append("parkingSpaceName,");
        }
        String isShowSyncAuth = "true";
        if (this.parkParamsService.isLprCamera()) {
            if (this.parkParamsService.isChineseLanguage()) {
                showColumns.append("cardNo,");
            }
        } else {
            isShowSyncAuth = "false";
        }
        if ("many".equals(this.parkParamsService.getParkingLotModel()) || "zkteco-park".equals(this.parkParamsService.getParkingLotCommMode())) {
            isShowSyncAuth = "false";
        }
        this.request.setAttribute("isShowSyncAuth", (Object)isShowSyncAuth);
        this.request.setAttribute("showColumns", (Object)showColumns.toString());
        return new ModelAndView("park/authorize/parkAuthorize");
    }

    @RequiresPermissions(value={"park:authorize:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        ParkAuthorizeItem parkAuthorizeItem = this.parkAuthorizeService.getItemById(id);
        this.request.setAttribute("item", (Object)parkAuthorizeItem);
        if (StringUtils.isNotBlank((CharSequence)parkAuthorizeItem.getModelAndView())) {
            return new ModelAndView(parkAuthorizeItem.getModelAndView());
        }
        return new ModelAndView("park/authorize/editParkAuthorize");
    }

    public ZKResultMsg checkAuthorizeTmpCarType(@RequestParam(value="id", required=false) String id) {
        ZKResultMsg res = new ZKResultMsg((Object)false);
        ParkAuthorizeItem parkAuthorizeItem = this.parkAuthorizeService.getItemById(id);
        if ("tempA".equals(parkAuthorizeItem.getCarTypeCode())) {
            res.setData((Object)true);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @LogRequest(module="park_module", object="park_leftMenu_authorizeManage", opType="park_authorize_add", requestParams={"personName"}, opContent="park_authorize_add")
    @RequiresPermissions(value={"park:authorize:edit"})
    public ZKResultMsg save(ParkAuthorizeItem item) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceResultList = this.parkAuthorizeService.saveItem(item);
        res.setData((Object)parkDeviceResultList);
        if (this.parkParamsService.isDisplayParkingSpace() || !this.parkParamsService.isFixedStatistical()) {
            this.parkWebsocketService.totalParkingSpaces();
        }
        return res;
    }

    @LogRequest(module="park_module", object="park_leftMenu_authorizeManage", opType="park_authorize_temporaryCaAdd", requestParams={"parkEntZoneNames"}, opContent="park_authorize_temporaryCaAdd")
    @RequiresPermissions(value={"park:authorize:edit"})
    public ZKResultMsg saveTempCar(ParkAuthorizeItem item) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceResultList = this.parkAuthorizeService.saveTempCarItem(item);
        res.setData((Object)parkDeviceResultList);
        return res;
    }

    @RequiresPermissions(value={"park:authorize:refresh"})
    public DxGrid list(ParkAuthorizeItem codition) {
        SecuritySubject authUser = this.authSessionServcie.getSecuritySubject(this.request.getSession().getId());
        if (!authUser.getIsSuperuser().booleanValue() && CollectionUtils.isNotEmpty((Collection)authUser.getDepartmentIds())) {
            codition.setDeptIdIn(StrUtil.collectionToStr((Collection)authUser.getDepartmentIds()));
        }
        codition.setStatus(Short.valueOf((short)1));
        Pager pager = this.parkAuthorizeService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="park_module", object="park_leftMenu_authorizeManage", opType="park_authorize_del", requestParams={"names"}, opContent="park_authorize_del")
    @RequiresPermissions(value={"park:authorize:del"})
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceResultList = this.parkAuthorizeService.delByIds(ids);
        res.setData((Object)parkDeviceResultList);
        return res;
    }

    public TreeItem getEntranceAreaTree(@RequestParam(value="parkingSpaceId", required=false) String parkingSpaceId, @RequestParam(value="init", required=false) Boolean init) {
        List treeItems = new ArrayList();
        if (init != null && !init.booleanValue()) {
            String parkingLotIds = this.parkParkingLotService.getParkingLotIdsByAuthFilter(this.request.getSession().getId());
            treeItems = StringUtils.isBlank((CharSequence)parkingLotIds) ? this.parkAuthorizeService.getEntranceAreaTree(parkingSpaceId) : this.parkAuthorizeService.getEntranceAreaTreeList(parkingSpaceId, parkingLotIds);
        }
        return new TreeItem("0", treeItems);
    }

    @RequiresPermissions(value={"park:authorize:batchAuthorize"})
    public ModelAndView batchAdd() {
        String parkingLotModel = this.parkParamsService.getParkingLotModel();
        this.request.setAttribute("fixedFeeScale", (Object)this.parkParamsService.isFixedFeeScale());
        this.request.setAttribute("nowTime", (Object)DateUtil.getDate((Date)new Date(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD));
        if ("one".equals(parkingLotModel)) {
            if (this.parkParamsService.isDisplayParkingSpace()) {
                this.request.setAttribute("showColumns", (Object)"checkbox,persName,persLastName,carNumber,parkingLot");
                return new ModelAndView("park/authorize/opParkAuthorizeByCarNumberEx");
            }
            this.request.setAttribute("showColumns", (Object)"checkbox,persName,persLastName,carNumber");
            return new ModelAndView("park/authorize/opParkAuthorizeByCarNumber");
        }
        if (this.parkParamsService.isDisplayParkingSpace()) {
            this.request.setAttribute("showColumns", (Object)"checkbox,persName,persLastName,carNumbers,parkingLot");
            return new ModelAndView("park/authorize/opParkAuthorizeByPersonEx");
        }
        this.request.setAttribute("showColumns", (Object)"checkbox,persName,persLastName,carNumbers");
        return new ModelAndView("park/authorize/opParkAuthorizeByPerson");
    }

    @LogRequest(module="park_module", object="park_leftMenu_authorizeManage", opType="park_authorize_batchAuthorize", requestParams={"saveLogValue"}, opContent="park_authorize_batchAuthorize")
    @RequiresPermissions(value={"park:authorize:batchAuthorize"})
    public ZKResultMsg saveBatchAuthorize(ParkAuthorizeItem item) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceResultList = this.parkAuthorizeService.saveBatchAuthorize(item);
        res.setData((Object)parkDeviceResultList);
        if (this.parkParamsService.isDisplayParkingSpace() || !this.parkParamsService.isFixedStatistical()) {
            this.parkWebsocketService.totalParkingSpaces();
        }
        return res;
    }

    @RequiresPermissions(value={"park:authorize:syncAuth"})
    @LogRequest(module="park_module", object="park_leftMenu_authorizeManage", opType="park_authorize_syncAuthorize", requestParams={}, opContent="park_authorize_syncAuthorize")
    public ZKResultMsg syncAuth() {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceResultList = this.parkAuthorizeService.syncAuth();
        res.setData((Object)parkDeviceResultList);
        return res;
    }

    public ZKResultMsg isExistAuthorizeTemp() {
        return new ZKResultMsg((Object)this.parkAuthorizeService.isExistAuthorizeTemp());
    }

    @RequiresPermissions(value={"park:authorize:export"})
    @LogRequest(module="park_module", object="park_leftMenu_authorizeManage", opType="common_op_export", requestParams={}, opContent="common_op_export")
    public void parkAuthorizeExport(HttpServletRequest request, HttpServletResponse response) {
        ParkAuthorizeItem parkAuthorizeItem = new ParkAuthorizeItem();
        parkAuthorizeItem.setStatus(Short.valueOf((short)1));
        this.setConditionValue((BaseItem)parkAuthorizeItem);
        List itemData = this.parkAuthorizeService.getItemData(parkAuthorizeItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemData, ParkAuthorizeItem.class);
    }

    @LogRequest(module="park_module", object="park_leftMenu_authorizeManage", opType="park_authorize_batchArea", requestParams={"personName"}, opContent="park_authorize_batchArea")
    @RequiresPermissions(value={"park:authorize:batchArea"})
    public ZKResultMsg batchAreaEntranceSave(@RequestParam(value="authIds", required=false) String authIds, @RequestParam(value="parkEntZoneIds", required=false) String parkEntZoneIds) {
        this.parkAuthorizeService.batchAreaEntranceSave(authIds, parkEntZoneIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

