/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.app.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.vo.AppResultMessage;
import com.zkteco.zkbiosecurity.park.app.service.ParkAppService;
import com.zkteco.zkbiosecurity.park.app.vo.ParkAppChannelItem;
import com.zkteco.zkbiosecurity.park.app.vo.ParkAppFixCarLienceItem;
import com.zkteco.zkbiosecurity.park.app.vo.ParkAppPavilioItem;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@ApiIgnore
@RequestMapping(value={"/app/v1"})
public class ParkAppController {
    @Autowired
    private ParkAppService parkAppService;

    @RequestMapping(value={"/getParkParams"}, method={RequestMethod.POST})
    public AppResultMessage getParams() {
        return this.parkAppService.getParkParam();
    }

    @RequestMapping(value={"/setParkParams"}, method={RequestMethod.POST})
    public AppResultMessage setParams(@RequestBody Map<String, String> message) {
        return this.parkAppService.setParkParam(message);
    }

    @RequestMapping(value={"/getParkCarType"}, method={RequestMethod.POST})
    public AppResultMessage getParkCarType() {
        return this.parkAppService.getParkCarType();
    }

    @RequestMapping(value={"/getParkCarLicensePlate"}, method={RequestMethod.POST})
    public AppResultMessage getParkCarLicensePlate() {
        return this.parkAppService.getParkCarLicensePlate();
    }

    @RequestMapping(value={"/getParkChargeDetail"}, method={RequestMethod.POST})
    public AppResultMessage getParkChargeDetail(@RequestBody JSONObject message) {
        int pageNo = StringUtils.isNotBlank((CharSequence)message.getString("pageNo")) ? Integer.parseInt(message.getString("pageNo")) : 1;
        int pageSize = StringUtils.isNotBlank((CharSequence)message.getString("pageSize")) ? Integer.parseInt(message.getString("pageSize")) : 20;
        String carNoOrOperator = StringUtils.isNotBlank((CharSequence)message.getString("carNoOrOperator")) ? message.getString("carNoOrOperator") : "";
        String startTimeStr = message.getString("startTime");
        String endTimeStr = message.getString("endTime");
        return this.parkAppService.getParkChargeDetail(carNoOrOperator, startTimeStr, endTimeStr, pageNo - 1, pageSize);
    }

    @RequestMapping(value={"/getParkChargeDetailById"}, method={RequestMethod.POST})
    public AppResultMessage getParkChargeDetailById(@RequestBody JSONObject message) {
        return this.parkAppService.getParkChargeDetailById(message.getString("id"));
    }

    @RequestMapping(value={"/getParkRecordin"}, method={RequestMethod.POST})
    public AppResultMessage getParkRecordin(@RequestBody JSONObject message) {
        int pageNo = StringUtils.isNotBlank((CharSequence)message.getString("pageNo")) ? Integer.parseInt(message.getString("pageNo")) : 1;
        int pageSize = StringUtils.isNotBlank((CharSequence)message.getString("pageSize")) ? Integer.parseInt(message.getString("pageSize")) : 20;
        String carNumber = StringUtils.isNotBlank((CharSequence)message.getString("carNumber")) ? message.getString("carNumber") : "";
        String startTimeStr = message.getString("startTime");
        String endTimeStr = message.getString("endTime");
        return this.parkAppService.getParkRecordin(carNumber, startTimeStr, endTimeStr, pageNo - 1, pageSize);
    }

    @RequestMapping(value={"/getParkRecordinById"}, method={RequestMethod.POST})
    public AppResultMessage getParkRecordinById(@RequestBody JSONObject message) {
        return this.parkAppService.getParkRecordinById(message.getString("id"));
    }

    @RequestMapping(value={"/getParkChannel"}, method={RequestMethod.POST})
    public AppResultMessage getParkChannel(@RequestBody JSONObject message) {
        int pageNo = StringUtils.isNotBlank((CharSequence)message.getString("pageNo")) ? Integer.parseInt(message.getString("pageNo")) : 1;
        int pageSize = StringUtils.isNotBlank((CharSequence)message.getString("pageSize")) ? Integer.parseInt(message.getString("pageSize")) : 20;
        return this.parkAppService.getParkChannel(pageNo - 1, pageSize);
    }

    @RequestMapping(value={"/getParkChannelById"}, method={RequestMethod.POST})
    public AppResultMessage getParkChannelById(@RequestBody JSONObject message) {
        return this.parkAppService.getParkChannelById(message.getString("id"));
    }

    @RequestMapping(value={"/delParkChannel"}, method={RequestMethod.POST})
    public AppResultMessage delParkChannel(@RequestBody JSONObject message) {
        return this.parkAppService.delParkChannel(message.getString("id"));
    }

    @RequestMapping(value={"/ManualChannelOpening"}, method={RequestMethod.POST})
    public AppResultMessage manualChannelOpening(@RequestBody JSONObject message) {
        return this.parkAppService.manualChannelOpening(message.getString("id"));
    }

    @RequestMapping(value={"/editParkChannel"}, method={RequestMethod.POST})
    public AppResultMessage editParkChannel(@RequestBody ParkAppChannelItem parkAppChannelItem) {
        return this.parkAppService.editParkChannel(parkAppChannelItem);
    }

    @RequestMapping(value={"/getParkDeviceIps"}, method={RequestMethod.POST})
    public AppResultMessage getParkDeviceIps(@RequestBody JSONObject message) {
        return this.parkAppService.getParkDeviceIps(message.getString("id"));
    }

    @RequestMapping(value={"/getParkPavilio"}, method={RequestMethod.POST})
    public AppResultMessage getParkPavilio(@RequestBody JSONObject message) {
        int pageNo = StringUtils.isNotBlank((CharSequence)message.getString("pageNo")) ? Integer.parseInt(message.getString("pageNo")) : 1;
        int pageSize = StringUtils.isNotBlank((CharSequence)message.getString("pageSize")) ? Integer.parseInt(message.getString("pageSize")) : 20;
        return this.parkAppService.getParkPavilio(pageNo - 1, pageSize);
    }

    @RequestMapping(value={"/getParkPavilioById"}, method={RequestMethod.POST})
    public AppResultMessage getParkPavilioById(@RequestBody JSONObject message) {
        return this.parkAppService.getParkPavilioById(message.getString("id"));
    }

    @RequestMapping(value={"/delParkPavilio"}, method={RequestMethod.POST})
    public AppResultMessage delParkPavilio(@RequestBody JSONObject message) {
        return this.parkAppService.delParkPavilio(message.getString("id"));
    }

    @RequestMapping(value={"/editParkPavilio"}, method={RequestMethod.POST})
    public AppResultMessage editParkPavilio(@RequestBody ParkAppPavilioItem parkAppPavilioItem) {
        return this.parkAppService.editParkPavilio(parkAppPavilioItem);
    }

    @RequestMapping(value={"/getParkEntranceArea"}, method={RequestMethod.POST})
    public AppResultMessage getParkEntranceArea(@RequestBody JSONObject message) {
        int pageNo = StringUtils.isNotBlank((CharSequence)message.getString("pageNo")) ? Integer.parseInt(message.getString("pageNo")) : 1;
        int pageSize = StringUtils.isNotBlank((CharSequence)message.getString("pageSize")) ? Integer.parseInt(message.getString("pageSize")) : 20;
        String parkEntranceAreaName = StringUtils.isNotBlank((CharSequence)message.getString("parkEntranceAreaName")) ? message.getString("parkEntranceAreaName") : "";
        String parkParkingAreaType = StringUtils.isNotBlank((CharSequence)message.getString("parkParkingAreaType")) ? message.getString("parkParkingAreaType") : "";
        String parkSpaceId = StringUtils.isNotBlank((CharSequence)message.getString("parkSpaceId")) ? message.getString("parkSpaceId") : "";
        return this.parkAppService.getParkEntranceArea(parkEntranceAreaName, parkParkingAreaType, parkSpaceId, pageNo - 1, pageSize);
    }

    @RequestMapping(value={"/getParkLotandAreaById"}, method={RequestMethod.POST})
    public AppResultMessage getParkLotandAreaById(@RequestBody JSONObject message) {
        return this.parkAppService.getParkLotandAreaById(message.getString("parkEntranceAreaId"));
    }

    @RequestMapping(value={"/getParkCarDelay"}, method={RequestMethod.POST})
    public AppResultMessage getParkCarDelay(@RequestBody JSONObject message) {
        int pageNo = StringUtils.isNotBlank((CharSequence)message.getString("pageNo")) ? Integer.parseInt(message.getString("pageNo")) : 1;
        int pageSize = StringUtils.isNotBlank((CharSequence)message.getString("pageSize")) ? Integer.parseInt(message.getString("pageSize")) : 20;
        String token = message.getString("token");
        return this.parkAppService.getParkCarDelay(token, pageNo - 1, pageSize);
    }

    @RequestMapping(value={"/getParkCarDelayById"}, method={RequestMethod.POST})
    public AppResultMessage getParkCarDelayById(@RequestBody JSONObject message) {
        return this.parkAppService.getParkCarDelayById(message.getString("id"));
    }

    @RequestMapping(value={"/editParkCarDelay"}, method={RequestMethod.POST})
    public AppResultMessage editParkCarDelay(@RequestBody JSONObject message) {
        String token = message.getString("token");
        String authorizeId = message.getString("id");
        String delayMoney = message.getString("delayMoney");
        String delayTime = message.getString("delayTime");
        return this.parkAppService.editParkCarDelay(token, authorizeId, delayMoney, delayTime);
    }

    @RequestMapping(value={"/FixCarCancel"}, method={RequestMethod.POST})
    public AppResultMessage fixCarCancel(@RequestBody JSONObject message) {
        return this.parkAppService.fixCarCancel(message.getString("token"), message.getString("id"));
    }

    @RequestMapping(value={"/getParkAuthorize"}, method={RequestMethod.POST})
    public AppResultMessage getParkAuthorize(@RequestBody JSONObject message) {
        int pageNo = StringUtils.isNotBlank((CharSequence)message.getString("pageNo")) ? Integer.parseInt(message.getString("pageNo")) : 1;
        int pageSize = StringUtils.isNotBlank((CharSequence)message.getString("pageSize")) ? Integer.parseInt(message.getString("pageSize")) : 20;
        return this.parkAppService.getParkAuthorize(message.getString("token"), pageNo - 1, pageSize);
    }

    @RequestMapping(value={"/getParkAuthorizeById"}, method={RequestMethod.POST})
    public AppResultMessage getParkAuthorizeById(@RequestBody JSONObject message) {
        return this.parkAppService.getParkAuthorizeById(message.getString("id"));
    }

    @RequestMapping(value={"/editFixCarLience"}, method={RequestMethod.POST})
    public AppResultMessage editFixCarLience(@RequestBody ParkAppFixCarLienceItem parkAppFixCarLienceItem) {
        return this.parkAppService.editFixCarLience(parkAppFixCarLienceItem);
    }

    @RequestMapping(value={"/editTempCarLience"}, method={RequestMethod.POST})
    public AppResultMessage editTempCarLience(@RequestBody JSONObject message) {
        String entranceAreaId = message.getString("entranceAreaId");
        String token = message.getString("token");
        return this.parkAppService.editTempCarLience(token, entranceAreaId);
    }

    @RequestMapping(value={"/isTempCarExist"}, method={RequestMethod.POST})
    public AppResultMessage isTempCarExist() {
        return this.parkAppService.isTempCarExist();
    }

    @RequestMapping(value={"/getFixCarChargeByCarTypeId"}, method={RequestMethod.POST})
    public AppResultMessage getFixCarChargeByCarTypeId(@RequestBody JSONObject message) {
        return this.parkAppService.getFixCarChargeByCarTypeId(message.getString("carTypeName"));
    }

    @RequestMapping(value={"/getParkPerson"}, method={RequestMethod.POST})
    public AppResultMessage getParkPerson(@RequestBody JSONObject message) {
        int pageNo = StringUtils.isNotBlank((CharSequence)message.getString("pageNo")) ? Integer.parseInt(message.getString("pageNo")) : 1;
        int pageSize = StringUtils.isNotBlank((CharSequence)message.getString("pageSize")) ? Integer.parseInt(message.getString("pageSize")) : 20;
        String nameOrPin = StringUtils.isNotBlank((CharSequence)message.getString("name")) ? message.getString("name") : "";
        String token = message.getString("token");
        return this.parkAppService.getParkPerson(token, nameOrPin, pageNo, pageSize);
    }

    @RequestMapping(value={"/getCarNumberByPersonPin"}, method={RequestMethod.POST})
    public AppResultMessage getCarNumberByPersonPin(@RequestBody JSONObject message) {
        return this.parkAppService.getCarNumberByPersonPin(message.getString("personPin"));
    }

    @RequestMapping(value={"/parkAuthorizeLogout"}, method={RequestMethod.POST})
    public AppResultMessage parkAuthorizeLogout(@RequestBody JSONObject message) {
        return this.parkAppService.fixCarCancel(message.getString("token"), message.getString("id"));
    }

    @RequestMapping(value={"/getParkParkingSpace"}, method={RequestMethod.POST})
    public AppResultMessage getParkParkingSpace(@RequestBody JSONObject message) {
        int pageNo = StringUtils.isNotBlank((CharSequence)message.getString("pageNo")) ? Integer.parseInt(message.getString("pageNo")) : 1;
        int pageSize = StringUtils.isNotBlank((CharSequence)message.getString("pageSize")) ? Integer.parseInt(message.getString("pageSize")) : 20;
        String condition = StringUtils.isNotBlank((CharSequence)message.getString("condition")) ? message.getString("condition") : "";
        String id = message.getString("id");
        return this.parkAppService.getParkParkingSpace(id, condition, pageNo - 1, pageSize);
    }

    @RequestMapping(value={"/getParkingLotModel"}, method={RequestMethod.POST})
    public AppResultMessage getParkingLotModel() {
        return this.parkAppService.getParkingLotModel();
    }

    @RequestMapping(value={"/isModelExist"}, method={RequestMethod.POST})
    public AppResultMessage isModelExist() {
        return this.parkAppService.isModelExist();
    }

    @RequestMapping(value={"/getParkDoorFilterByChannel"}, method={RequestMethod.POST})
    public AppResultMessage getParkDoorFilterByChannel(@RequestBody JSONObject message) {
        String parkAccDoorId = StringUtils.isNotBlank((CharSequence)message.getString("parkAccDoorId")) ? message.getString("parkAccDoorId") : "-1";
        return this.parkAppService.getParkDoorFilterByChannel(parkAccDoorId);
    }

    @RequestMapping(value={"/getChannelInfo"}, method={RequestMethod.POST})
    public AppResultMessage getChannelInfo(@RequestBody JSONObject message) {
        String parkChannelId = StringUtils.isNotBlank((CharSequence)message.getString("channelId")) ? message.getString("channelId") : "";
        return this.parkAppService.getChannelInfo(parkChannelId);
    }
}

