/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.api.controller;

import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.park.api.controller.ParkApiController;
import com.zkteco.zkbiosecurity.park.api.vo.ParkApiRecordInItem;
import com.zkteco.zkbiosecurity.park.api.vo.ParkApiRecordOutItem;
import com.zkteco.zkbiosecurity.park.enums.ParkApiCodeErrorEnum;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinSideService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordoutService;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordinSideItem;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordoutItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"ParkTransaction"}, description="park transaction")
@Controller
@RequestMapping(value={"/api/v2/parkTransaction"})
public class ParkApiV2TransactionController
implements ParkApiController {
    private static final Logger log = LoggerFactory.getLogger(ParkApiV2TransactionController.class);
    @Autowired
    private ParkRecordinSideService parkRecordinSideService;
    @Autowired
    private ParkRecordoutService parkRecordoutService;

    @ApiOperation(value="Plate RecordIn", notes="Plate RecordIn", response=ApiResultMessage.class)
    @ResponseBody
    @RequestMapping(value={"/listParkRecordin"}, method={RequestMethod.GET}, produces={"application/json"})
    public ApiResultMessage listParkRecordin(@RequestParam(name="carNumber", required=false) String carNumber, @ApiParam(value="yyyy-MM-dd HH:mm:ss") @RequestParam(name="startDate", required=false) String startDate, @ApiParam(value="yyyy-MM-dd HH:mm:ss") @RequestParam(name="endDate", required=false) String endDate, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        ApiResultMessage rs;
        try {
            rs = this.checkParams(pageNo, pageSize, startDate, endDate);
            if (Objects.nonNull(rs)) {
                return rs;
            }
            rs = new ApiResultMessage();
            ParkRecordinSideItem recordInSideItem = new ParkRecordinSideItem();
            if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
                Date startTime = DateUtil.stringToDate((String)startDate);
                Date endTime = DateUtil.stringToDate((String)endDate);
                recordInSideItem.setTimeBegin(startTime);
                recordInSideItem.setTimeEnd(endTime);
            }
            if (StringUtils.isNotBlank((CharSequence)carNumber)) {
                recordInSideItem.setCarNumber(carNumber);
            }
            ArrayList parkApiRecordInItemList = Lists.newArrayList();
            Pager pager = this.parkRecordinSideService.getItemsByPage((BaseItem)recordInSideItem, pageNo - 1, pageSize.intValue());
            List parkRecordinList = pager.getData();
            if (CollectionUtils.isNotEmpty((Collection)parkRecordinList)) {
                parkRecordinList.forEach(parkRecordinSideItem -> {
                    ParkApiRecordInItem parkApiRecordInItem = ParkApiRecordInItem.createParkRecordIn((ParkRecordinSideItem)parkRecordinSideItem);
                    if (Objects.nonNull(parkApiRecordInItem)) {
                        parkApiRecordInItemList.add(parkApiRecordInItem);
                    }
                });
            }
            pager.setData((List)parkApiRecordInItemList);
            rs.setData((Object)pager);
        }
        catch (Exception e) {
            log.error("parkTransaction/listParkRecordin error", (Throwable)e);
            rs = this.getApiMessage(ParkApiCodeErrorEnum.ProgramError_Error);
        }
        return rs;
    }

    @ApiOperation(value="Plate Recordout", notes="Plate Recordout", response=ApiResultMessage.class)
    @ResponseBody
    @RequestMapping(value={"/listParkRecordout"}, method={RequestMethod.GET}, produces={"application/json"})
    public ApiResultMessage listParkRecordout(@RequestParam(name="carNumber", required=false) String carNumber, @ApiParam(value="yyyy-MM-dd HH:mm:ss") @RequestParam(name="startDate", required=false) String startDate, @ApiParam(value="yyyy-MM-dd HH:mm:ss") @RequestParam(name="endDate", required=false) String endDate, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        ApiResultMessage rs;
        try {
            rs = this.checkParams(pageNo, pageSize, startDate, endDate);
            if (Objects.nonNull(rs)) {
                return rs;
            }
            rs = new ApiResultMessage();
            ParkRecordoutItem recordOutItem = new ParkRecordoutItem();
            if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
                Date startTime = DateUtil.stringToDate((String)startDate);
                Date endTime = DateUtil.stringToDate((String)endDate);
                recordOutItem.setTimeBegin(startTime);
                recordOutItem.setTimeEnd(endTime);
            }
            if (StringUtils.isNotBlank((CharSequence)carNumber)) {
                recordOutItem.setCarNumber(carNumber);
            }
            ArrayList parkApiRecordOutItemList = Lists.newArrayList();
            Pager pager = this.parkRecordoutService.getItemsByPage((BaseItem)recordOutItem, pageNo - 1, pageSize.intValue());
            List parkRecordoutList = pager.getData();
            if (CollectionUtils.isNotEmpty((Collection)parkRecordoutList)) {
                parkRecordoutList.forEach(parkRecordoutItem -> {
                    ParkApiRecordOutItem parkApiRecordOutItem = ParkApiRecordOutItem.createParkRecordout((ParkRecordoutItem)parkRecordoutItem);
                    if (Objects.nonNull(parkApiRecordOutItem)) {
                        parkApiRecordOutItemList.add(parkApiRecordOutItem);
                    }
                });
            }
            pager.setData((List)parkApiRecordOutItemList);
            rs.setData((Object)pager);
        }
        catch (Exception e) {
            log.error("parkTransaction/listParkRecordout error", (Throwable)e);
            rs = this.getApiMessage(ParkApiCodeErrorEnum.ProgramError_Error);
        }
        return rs;
    }

    private ApiResultMessage checkParams(Integer pageNo, Integer pageSize, String startDate, String endDate) {
        ApiResultMessage apiResultMessage = this.checkPageParams(pageNo, pageSize);
        if (Objects.nonNull(apiResultMessage)) {
            return apiResultMessage;
        }
        if (StringUtils.isNotBlank((CharSequence)startDate) || StringUtils.isNotBlank((CharSequence)endDate)) {
            Date startTime = DateUtil.stringToDate((String)startDate);
            Date endTime = DateUtil.stringToDate((String)endDate);
            if (startTime == null || endTime == null) {
                return this.getApiMessage(ParkApiCodeErrorEnum.FormatTime_Error);
            }
            if (startTime.getTime() > endTime.getTime()) {
                return this.getApiMessage(ParkApiCodeErrorEnum.StartTimeGtEndTime_Error);
            }
        }
        return null;
    }
}

