/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.api.controller;

import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.park.api.controller.ParkApiController;
import com.zkteco.zkbiosecurity.park.api.service.ParkApiService;
import com.zkteco.zkbiosecurity.park.enums.ParkApiCodeErrorEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"ParkAuthorize"}, description="park license plate")
@Controller
@RequestMapping(value={"/api/v2/parkPlate"})
public class ParkApiV2AuthorizeController
implements ParkApiController {
    private static final Logger log = LoggerFactory.getLogger(ParkApiV2AuthorizeController.class);
    @Autowired
    private ParkApiService parkApiService;

    @ApiOperation(value="Add Or Update Allow Disabled Plate", notes="Add Or Update Allow Disabled Plate", response=ApiResultMessage.class)
    @ResponseBody
    @RequestMapping(value={"/addAllowDisabled"}, method={RequestMethod.POST}, produces={"application/json"})
    public ApiResultMessage addAllowDisabled(@ApiParam(value="0\uff1a\u5141\u8bb8\u30011\uff1a\u7981\u6b62") @RequestParam String type, @ApiParam(value="\u8f66\u724c") @RequestParam String carNumber, @ApiParam(value="\u7f16\u8f91\u524d\u8f66\u724c") @RequestParam(value="oldCarNumber", required=false) String oldCarNumber, @ApiParam(value="\u8f66\u573a\u7f16\u7801") @RequestParam(value="parkCode", required=false) String parkCode, @ApiParam(value="yyyy-MM-dd") @RequestParam String fromTime, @ApiParam(value="yyyy-MM-dd") @RequestParam String toTime) {
        ApiResultMessage rm;
        try {
            rm = this.parkApiService.addBlackWhite(type, carNumber, oldCarNumber, parkCode, fromTime, toTime);
        }
        catch (Exception e) {
            log.error("api parkAuthorize/addAllowDisabled error", (Throwable)e);
            rm = this.getApiMessage(ParkApiCodeErrorEnum.ProgramError_Error);
        }
        return rm;
    }
}

