/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.api.controller;

import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.park.api.controller.ParkApiController;
import com.zkteco.zkbiosecurity.park.api.service.ParkApiService;
import com.zkteco.zkbiosecurity.park.enums.ParkApiCodeErrorEnum;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@ApiIgnore
@Controller
@RequestMapping(value={"/api/parkAuthorize"})
public class ParkApiExpiredAuthorizeController
implements ParkApiController {
    private static final Logger log = LoggerFactory.getLogger(ParkApiExpiredAuthorizeController.class);
    @Autowired
    private ParkApiService parkApiService;

    @ApiOperation(value="Add Black White Plate", notes="Add Black White Plate", response=ApiResultMessage.class)
    @ResponseBody
    @RequestMapping(value={"/addBlackWhite"}, method={RequestMethod.POST}, produces={"application/json"})
    public ApiResultMessage addBlackWhite(@ApiParam(value="0\uff1a\u5141\u8bb8\u30011\uff1a\u7981\u6b62") @RequestParam String type, @RequestParam String carNumber, @ApiParam(value="yyyy-MM-dd") @RequestParam String fromTime, @ApiParam(value="yyyy-MM-dd") @RequestParam String toTime) {
        ApiResultMessage rm;
        try {
            rm = this.parkApiService.addBlackWhite(type, carNumber, fromTime, toTime);
        }
        catch (Exception e) {
            log.error("api parkAuthorize/addBlackWhite error", (Throwable)e);
            rm = this.getApiMessage(ParkApiCodeErrorEnum.ProgramError_Error);
        }
        return rm;
    }

    @ApiOperation(value="Delete Black WhiteAdd Plate", notes="Delete Black WhiteAdd Plate", response=ApiResultMessage.class)
    @ResponseBody
    @RequestMapping(value={"/delBlackWhite"}, method={RequestMethod.POST}, produces={"application/json"})
    public ApiResultMessage delBlackWhite(@RequestParam String carNumber) {
        ApiResultMessage rm;
        try {
            rm = this.parkApiService.delBlackWhite(carNumber);
        }
        catch (Exception e) {
            log.error("api parkAuthorize/delBlackWhite error", (Throwable)e);
            rm = this.getApiMessage(ParkApiCodeErrorEnum.ProgramError_Error);
        }
        return rm;
    }

    @ApiOperation(value="Edit Black White Plate", notes="Edit Black White Plate", response=ApiResultMessage.class)
    @ResponseBody
    @RequestMapping(value={"/editBlackWhite"}, method={RequestMethod.POST}, produces={"application/json"})
    public ApiResultMessage editBlackWhite(@ApiParam(value="0\uff1a\u5141\u8bb8\u30011\uff1a\u7981\u6b62") @RequestParam String type, @ApiParam(value="\u65b0\u8f66\u724c") @RequestParam String carNumber, @ApiParam(value="\u7f16\u8f91\u524d\u8f66\u724c") @RequestParam String oldCarNumber, @ApiParam(value="yyyy-MM-dd") @RequestParam String fromTime, @ApiParam(value="yyyy-MM-dd") @RequestParam String toTime) {
        ApiResultMessage rm;
        try {
            rm = this.parkApiService.editBlackWhite(type, carNumber, oldCarNumber, fromTime, toTime);
        }
        catch (Exception e) {
            log.error("api parkAuthorize/editBlackWhite error", (Throwable)e);
            rm = this.getApiMessage(ParkApiCodeErrorEnum.ProgramError_Error);
        }
        return rm;
    }
}

