/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.api.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.park.api.service.ParkApiDataExchangeService;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@ApiIgnore
@RestController
@RequestMapping(value={"/token/v1"})
public class ParkApiDataExchangeController {
    private static final Logger log = LoggerFactory.getLogger(ParkApiDataExchangeController.class);
    @Autowired
    private ParkApiDataExchangeService parkApiDataExchangeService;

    @RequestMapping(value={"/postRealTimeData"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json"})
    public ApiResultMessage postRealTimeData(@RequestBody JSONObject plateData) {
        JSONObject infoPlate = plateData.getJSONObject("infoplate");
        if (Objects.nonNull(infoPlate)) {
            String plate = infoPlate.getString("Plate");
            String sn = infoPlate.getString("sn");
            String ipAddress = infoPlate.getString("ipAddress");
            String photoData = infoPlate.getString("img");
            log.info("postRealTimeData Plate:{} ipAddress:{} sn:{}", new Object[]{plate, ipAddress, sn});
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{plate, sn, ipAddress, photoData})) {
                String license = StringUtils.deleteWhitespace((String)plate);
                this.parkApiDataExchangeService.devRealTimeDataUpload(license, sn, ipAddress, photoData);
                return ApiResultMessage.successMessage();
            }
        }
        return ApiResultMessage.failedMessage((int)-1);
    }

    @RequestMapping(value={"/parkingHeartBeat"}, method={RequestMethod.GET}, produces={"application/json"})
    public ApiResultMessage getParkingPlateList() {
        log.info("parkingHeartBeat");
        return ApiResultMessage.successMessage();
    }
}

