/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.api.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.park.api.controller.ParkApiController;
import com.zkteco.zkbiosecurity.park.api.service.ParkApiClientService;
import com.zkteco.zkbiosecurity.park.api.vo.ParkApiClientPavilionLoginItem;
import com.zkteco.zkbiosecurity.park.api.vo.ParkApiClientRecordInOutItem;
import com.zkteco.zkbiosecurity.park.enums.ParkApiCodeErrorEnum;
import com.zkteco.zkbiosecurity.park.utils.ParkGetLocalIpAddrUtil;
import io.swagger.annotations.Api;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@ApiIgnore
@Api(tags={"ParkApiZKTecoClient"})
@RestController
@RequestMapping(value={"/api/client/v1"})
public class ParkApiClientInfoController
implements ParkApiController {
    @Autowired
    private ParkApiClientService parkApiClientService;

    @RequestMapping(value={"/pavilionActive"}, method={RequestMethod.POST}, consumes={"application/json"})
    public ApiResultMessage pavilionActive(@RequestBody ParkApiClientPavilionLoginItem loginItem) {
        if (StringUtils.isBlank((CharSequence)loginItem.getParkCode())) {
            return this.getApiMessage(ParkApiCodeErrorEnum.ParkCode_Error);
        }
        if (StringUtils.isBlank((CharSequence)loginItem.getAreaCode())) {
            return this.getApiMessage(ParkApiCodeErrorEnum.AreaCode_Error);
        }
        if (StringUtils.isBlank((CharSequence)loginItem.getPavilionCode())) {
            return this.getApiMessage(ParkApiCodeErrorEnum.RegisterCode_Error);
        }
        if (!ParkGetLocalIpAddrUtil.ipCheck(loginItem.getPavilionIp())) {
            return this.getApiMessage(ParkApiCodeErrorEnum.PavilionIp_Error);
        }
        return this.parkApiClientService.pavilionActive(loginItem);
    }

    @RequestMapping(value={"/getParkParams"}, method={RequestMethod.GET})
    public ApiResultMessage getParams(@RequestParam String parkCode) {
        return this.parkApiClientService.getParkingParams(parkCode);
    }

    @RequestMapping(value={"/getParkingCarType"}, method={RequestMethod.GET})
    public ApiResultMessage getParkingCarType(@RequestParam String parkCode) {
        return this.parkApiClientService.getParkingCarType(parkCode);
    }

    @RequestMapping(value={"/getParkingArea"}, method={RequestMethod.GET})
    public ApiResultMessage getParkingArea(@RequestParam String parkCode, @RequestParam String areaCode) {
        return this.parkApiClientService.getParkingArea(parkCode, areaCode);
    }

    @RequestMapping(value={"/postParkingPavilionInfo"}, method={RequestMethod.POST}, consumes={"application/json"})
    public ApiResultMessage postParkingPavilionInfo(@RequestBody ParkApiClientPavilionLoginItem loginItem) {
        if (StringUtils.isBlank((CharSequence)loginItem.getParkCode())) {
            return this.getApiMessage(ParkApiCodeErrorEnum.ParkCode_Error);
        }
        if (StringUtils.isBlank((CharSequence)loginItem.getPavilionCode())) {
            return this.getApiMessage(ParkApiCodeErrorEnum.RegisterCode_Error);
        }
        if (StringUtils.isBlank((CharSequence)loginItem.getPavilionIp())) {
            return this.getApiMessage(ParkApiCodeErrorEnum.PavilionIp_Error);
        }
        return this.parkApiClientService.postParkingPavilionInfo(loginItem);
    }

    @RequestMapping(value={"/getParkingChannelList"}, method={RequestMethod.GET})
    public ApiResultMessage getParkingChannelList(@RequestParam String parkCode, @RequestParam String pavilionIp) {
        return this.parkApiClientService.getParkingChannelList(parkCode, pavilionIp);
    }

    @RequestMapping(value={"/getParkingDeviceList"}, method={RequestMethod.GET})
    public ApiResultMessage getParkingDeviceList(@RequestParam String parkCode, @RequestParam String pavilionIp) {
        return this.parkApiClientService.getParkingDeviceList(parkCode, pavilionIp);
    }

    @RequestMapping(value={"/getParkingAllowForbiddenList"}, method={RequestMethod.GET})
    public ApiResultMessage getParkingAllowForbiddenList(@RequestParam String parkCode, @RequestParam(required=false) String areaCode) {
        return this.parkApiClientService.getParkingAllowForbiddenList(parkCode, areaCode);
    }

    @RequestMapping(value={"/getParkingPersonList"}, method={RequestMethod.GET})
    public ApiResultMessage getParkingPersonList(@RequestParam String parkCode, @RequestParam String areaCode) {
        return this.parkApiClientService.getParkingPersonList(parkCode, areaCode);
    }

    @RequestMapping(value={"/getParkingFixedAuthList"}, method={RequestMethod.GET})
    public ApiResultMessage getParkingFixedAuthList(@RequestParam String parkCode, @RequestParam String parkEntranceAreaId) {
        return this.parkApiClientService.getParkingFixedAuthList(parkCode, parkEntranceAreaId);
    }

    @RequestMapping(value={"/getParkingChargeList"}, method={RequestMethod.GET})
    public ApiResultMessage getParkingChargeList(@RequestParam String parkCode) {
        return ApiResultMessage.successMessage();
    }

    @RequestMapping(value={"/getParkingOvertimeChargeList"}, method={RequestMethod.GET})
    public ApiResultMessage getParkingOvertimeChargeList(@RequestParam String parkCode) {
        return ApiResultMessage.successMessage();
    }

    @RequestMapping(value={"/postParkingRecordIn"}, method={RequestMethod.POST})
    public ApiResultMessage postParkingRecordIn(@RequestBody ParkApiClientRecordInOutItem recordInOutItem) {
        return this.parkApiClientService.parkingRecordIn(recordInOutItem);
    }

    @RequestMapping(value={"/postParkingRecordOut"}, method={RequestMethod.POST})
    public ApiResultMessage postParkingRecordOut(@RequestBody ParkApiClientRecordInOutItem recordInOutItem) {
        return this.parkApiClientService.parkingRecordOut(recordInOutItem);
    }

    @RequestMapping(value={"/postParkingRecordInOutPicture"}, method={RequestMethod.POST}, produces={"application/json"})
    public ApiResultMessage postParkingRecordInOutPicture(@RequestBody JSONObject data) {
        return this.parkApiClientService.parkingRecordInOutPicture(data);
    }

    @RequestMapping(value={"/parkingHeartBeat"}, method={RequestMethod.POST}, produces={"application/json"})
    public ApiResultMessage heartBeat(@RequestBody JSONObject data) {
        String parkCode = data.getString("parkCode");
        if (StringUtils.isBlank((CharSequence)parkCode)) {
            return this.getApiMessage(ParkApiCodeErrorEnum.ParkCode_Error);
        }
        String pavilionId = data.getString("pavilionId");
        if (StringUtils.isBlank((CharSequence)pavilionId)) {
            return this.getApiMessage(ParkApiCodeErrorEnum.PavilionId_Error);
        }
        return this.parkApiClientService.heartBeat(data);
    }

    @RequestMapping(value={"/getParkingSyncTime"}, method={RequestMethod.GET}, produces={"application/json"})
    public ApiResultMessage syncTime(@RequestParam String parkCode) {
        return this.parkApiClientService.syncTime(parkCode);
    }

    @ModelAttribute
    public ApiResultMessage networkCheck() {
        return this.parkApiClientService.commActive();
    }

    @RequestMapping(value={"/parkingNetworkCheck"}, method={RequestMethod.GET})
    public ApiResultMessage networkCheck(@RequestParam String parkCode) {
        return ApiResultMessage.successMessage();
    }
}

