/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.api.controller;

import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.api.controller.ParkApiController;
import com.zkteco.zkbiosecurity.park.api.service.ParkApiService;
import com.zkteco.zkbiosecurity.park.api.vo.ParkApiCarNumberItem;
import com.zkteco.zkbiosecurity.park.enums.ParkApiCodeErrorEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"ParkAuthorize"}, description="park license plate")
@Controller
@RequestMapping(value={"/api/v1/parkPlate"})
public class ParkApiAuthorizeController
implements ParkApiController {
    private static final Logger log = LoggerFactory.getLogger(ParkApiAuthorizeController.class);
    @Autowired
    private ParkApiService parkApiService;

    @ApiOperation(value="Add Black White Plate", notes="Add Black White Plate", response=ApiResultMessage.class)
    @ResponseBody
    @RequestMapping(value={"/addBlackWhite"}, method={RequestMethod.POST}, produces={"application/json"})
    public ApiResultMessage addBlackWhite(@ApiParam(value="0\uff1a\u5141\u8bb8\u30011\uff1a\u7981\u6b62") @RequestParam String type, @ApiParam(value="\u8f66\u724c") @RequestParam String carNumber, @ApiParam(value="yyyy-MM-dd") @RequestParam String fromTime, @ApiParam(value="yyyy-MM-dd") @RequestParam String toTime) {
        ApiResultMessage rm;
        try {
            rm = this.parkApiService.addBlackWhite(type, carNumber, fromTime, toTime);
        }
        catch (Exception e) {
            log.error("api parkAuthorize/addBlackWhite error", (Throwable)e);
            rm = this.getApiMessage(ParkApiCodeErrorEnum.ProgramError_Error);
        }
        return rm;
    }

    @ApiOperation(value="Delete Black WhiteAdd Plate", notes="Delete Black WhiteAdd Plate", response=ApiResultMessage.class)
    @ResponseBody
    @RequestMapping(value={"/delBlackWhite"}, method={RequestMethod.POST}, produces={"application/json"})
    public ApiResultMessage delBlackWhite(@RequestParam String carNumber) {
        ApiResultMessage rm;
        try {
            rm = this.parkApiService.delBlackWhite(carNumber);
        }
        catch (Exception e) {
            log.error("api parkAuthorize/delBlackWhite error", (Throwable)e);
            rm = this.getApiMessage(ParkApiCodeErrorEnum.ProgramError_Error);
        }
        return rm;
    }

    @ApiOperation(value="Edit Black White Plate", notes="Edit Black White Plate", response=ApiResultMessage.class)
    @ResponseBody
    @RequestMapping(value={"/editBlackWhite"}, method={RequestMethod.POST}, produces={"application/json"})
    public ApiResultMessage editBlackWhite(@ApiParam(value="0\uff1a\u5141\u8bb8\u30011\uff1a\u7981\u6b62") @RequestParam String type, @ApiParam(value="\u65b0\u8f66\u724c") @RequestParam String carNumber, @ApiParam(value="\u7f16\u8f91\u524d\u8f66\u724c") @RequestParam String oldCarNumber, @ApiParam(value="yyyy-MM-dd") @RequestParam String fromTime, @ApiParam(value="yyyy-MM-dd") @RequestParam String toTime) {
        ApiResultMessage rm;
        try {
            rm = this.parkApiService.editBlackWhite(type, carNumber, oldCarNumber, fromTime, toTime);
        }
        catch (Exception e) {
            log.error("api parkAuthorize/editBlackWhite error", (Throwable)e);
            rm = this.getApiMessage(ParkApiCodeErrorEnum.ProgramError_Error);
        }
        return rm;
    }

    @ApiOperation(value="Add Or Update Person Plate", notes="Add Or Update Person Plate", response=ApiResultMessage.class)
    @RequestMapping(value={"/addPlate"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage addCarNumber(@RequestBody ParkApiCarNumberItem apiCarNumber) {
        ApiResultMessage rm;
        if (StringUtils.isBlank((CharSequence)apiCarNumber.getPin())) {
            return this.getApiMessage(ParkApiCodeErrorEnum.FieldIsEmpty_Error);
        }
        if (StringUtils.isBlank((CharSequence)apiCarNumber.getCarNumber())) {
            return this.getApiMessage(ParkApiCodeErrorEnum.CarNumberNotEmpty_Error);
        }
        try {
            rm = this.parkApiService.addCarNumber(apiCarNumber);
        }
        catch (ZKBusinessException e) {
            rm = ApiResultMessage.message((int)-1, (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("api parkAuthorize/addCarNumber error", (Throwable)e);
            rm = this.getApiMessage(ParkApiCodeErrorEnum.ProgramError_Error);
        }
        return rm;
    }

    @ApiOperation(value="Delete Person Plate", notes="Delete Person Plate By CarNumber", response=ApiResultMessage.class)
    @RequestMapping(value={"/delPlate"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage delCarNumber(@RequestBody ParkApiCarNumberItem apiCarNumber) {
        ApiResultMessage rm;
        if (StringUtils.isBlank((CharSequence)apiCarNumber.getPin())) {
            return this.getApiMessage(ParkApiCodeErrorEnum.PinNotEmpty_Error);
        }
        if (StringUtils.isBlank((CharSequence)apiCarNumber.getCarNumber())) {
            return this.getApiMessage(ParkApiCodeErrorEnum.CarNumberNotEmpty_Error);
        }
        try {
            rm = this.parkApiService.delCarNumber(apiCarNumber.getPin(), apiCarNumber.getCarNumber());
        }
        catch (ZKBusinessException e) {
            rm = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)e.getMessage(), (Object[])e.getObjects()));
        }
        catch (Exception e) {
            log.error("api parkAuthorize/delCarNumber error", (Throwable)e);
            rm = this.getApiMessage(ParkApiCodeErrorEnum.ProgramError_Error);
        }
        return rm;
    }
}

