/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vdb.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vdb.remote.VdbUnlockRecordsRemote;
import com.zkteco.zkbiosecurity.vdb.service.VdbBuildingService;
import com.zkteco.zkbiosecurity.vdb.service.VdbDeviceService;
import com.zkteco.zkbiosecurity.vdb.service.VdbUnlockRecordsService;
import com.zkteco.zkbiosecurity.vdb.vo.VdbRecordsSelectDeviceItem;
import com.zkteco.zkbiosecurity.vdb.vo.VdbUnlockRecordsItem;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VdbUnlockRecordsController
extends ExportController
implements VdbUnlockRecordsRemote {
    @Autowired
    private VdbUnlockRecordsService vdbUnlockRecordsService;
    @Autowired
    private VdbDeviceService vdbDeviceService;
    @Autowired
    private VdbBuildingService vdbBuildingService;

    @RequiresPermissions(value={"vdb:unlockRecords"})
    public ModelAndView index() {
        return new ModelAndView("vdb/unlockRecords/vdbUnlockRecords");
    }

    @RequiresPermissions(value={"vdb:unlockRecords:refresh"})
    public DxGrid list(VdbUnlockRecordsItem condition) {
        Pager pager = this.vdbUnlockRecordsService.loadRecordsByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @LogRequest(module="vdb_module", object="vdb_leftMenu_unlockRecords", opType="vdb_records_upload", requestParams={"deviceName"}, opContent="common_dev_name")
    @RequiresPermissions(value={"vdb:unlockRecords:upload"})
    public ZKResultMsg uploadRecords() {
        String selectDeviceId = this.request.getParameter("selectDeviceId");
        if (StringUtils.isNotBlank((CharSequence)selectDeviceId)) {
            this.vdbUnlockRecordsService.uploadRecordsByDeviceId(selectDeviceId);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"vdb:unlockRecords:export"})
    @LogRequest(module="vdb_module", object="vdb_leftMenu_unlockRecords", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        VdbUnlockRecordsItem vdbUnlockRecordsItem = new VdbUnlockRecordsItem();
        this.setConditionValue((BaseItem)vdbUnlockRecordsItem);
        String userId = this.vdbBuildingService.getUserIdBySessionId(request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            vdbUnlockRecordsItem.setAreaNameByUserId(userId);
        }
        List itemList = this.vdbUnlockRecordsService.getItemData(VdbUnlockRecordsItem.class, vdbUnlockRecordsItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, VdbUnlockRecordsItem.class);
    }

    public DxGrid selectDeviceList(VdbRecordsSelectDeviceItem condition) {
        condition.setDeviceTypeNot("3");
        if (StringUtils.isBlank((CharSequence)condition.getSelectId())) {
            condition.setSelectId("-1");
        }
        if (condition.getType().equals("noSelected")) {
            condition.setSelectDeviceIdsNotIn(condition.getSelectId());
        } else if (condition.getType().equals("selected")) {
            condition.setSelectDeviceIdsIn(condition.getSelectId());
        }
        Pager pager = this.vdbDeviceService.getSelectDevPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }
}

