/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vdb.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vdb.remote.VdbUnitRemote;
import com.zkteco.zkbiosecurity.vdb.service.VdbBuildingService;
import com.zkteco.zkbiosecurity.vdb.service.VdbUnitService;
import com.zkteco.zkbiosecurity.vdb.vo.VdbUnitItem;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VdbUnitController
extends ExportController
implements VdbUnitRemote {
    @Autowired
    private VdbUnitService vdbUnitService;
    @Autowired
    private VdbBuildingService vdbBuildingService;
    @Autowired
    private ProgressCache progressCache;

    @RequiresPermissions(value={"vdb:unit"})
    public ModelAndView index() {
        return new ModelAndView("vdb/unit/vdbUnit");
    }

    @RequiresPermissions(value={"vdb:unit:add", "vdb:unit:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            VdbUnitItem item = this.vdbUnitService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("vdb/unit/editVdbUnit");
    }

    @RequiresPermissions(value={"vdb:unit:add", "vdb:unit:edit"})
    @LogRequest(module="vdb_module", object="vdb_leftMenu_unit", opType="common_op_edit", requestParams={"name"}, opContent="vdb_unit_name")
    public ZKResultMsg save(VdbUnitItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.vdbUnitService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"vdb:unit:refresh"})
    public DxGrid list(VdbUnitItem condition) {
        Pager pager = this.vdbUnitService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vdb:unit:del"})
    @LogRequest(module="vdb_module", object="vdb_leftMenu_unit", opType="common_op_del", requestParams={"names"}, opContent="vdb_unit_name")
    public ZKResultMsg del(String ids) {
        this.vdbUnitService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String isExistName(String name) {
        VdbUnitItem item = this.vdbUnitService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    public boolean isExistUnitNo(String unitNo, String vdbBuildingId, String id) {
        VdbUnitItem item = new VdbUnitItem();
        item.setVdbBuildingId(vdbBuildingId);
        item.setUnitNo(unitNo);
        item.setIdNotEq(id);
        item = this.vdbUnitService.getItemByCondition(item);
        return item == null;
    }

    public TreeItem getUnitTree() {
        List treeItems = this.vdbUnitService.getUnitTree(this.request.getSession().getId());
        return new TreeItem("0", treeItems);
    }

    public ZKResultMsg getUnitByBuildingId(String buildingId) {
        if (StringUtils.isNotBlank((CharSequence)buildingId)) {
            VdbUnitItem vdbUnitItem = new VdbUnitItem();
            vdbUnitItem.setVdbBuildingId(buildingId);
            return new ZKResultMsg((Object)this.vdbUnitService.getSelectListByCondition(vdbUnitItem));
        }
        return new ZKResultMsg();
    }

    @RequiresPermissions(value={"vdb:unit:export"})
    @LogRequest(module="vdb_module", object="vdb_leftMenu_unit", opType="common_op_export", requestParams={}, opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        VdbUnitItem vdbUnitItem = new VdbUnitItem();
        this.setConditionValue((BaseItem)vdbUnitItem);
        String userId = this.vdbBuildingService.getUserIdBySessionId(request.getSession().getId());
        vdbUnitItem.setUserId(userId);
        List vdbUnitItemLists = this.vdbUnitService.getExportUnitItemList(vdbUnitItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(vdbUnitItemLists, VdbUnitItem.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"vdb:unit:import"})
    @LogRequest(module="vdb_module", object="vdb_leftMenu_unit", opType="common_op_import", requestParams={}, opContent="common_op_import")
    public ZKResultMsg importExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0]) + "<br/>"));
            List itemList = ExcelUtil.excelImport((InputStream)upload.getInputStream(), VdbUnitItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0]) + "<br/>"));
            boolean updateExistData = false;
            String isupdateExistData = this.request.getParameter("updateExistData");
            if ("1".equals(isupdateExistData)) {
                updateExistData = true;
            }
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.vdbUnitService.importUnitData(itemList, updateExistData));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import VdbBuilding Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    public TreeItem tree() {
        List itemList = this.vdbUnitService.loadItemsByAuthFilter(this.request.getSession().getId(), new VdbUnitItem());
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        for (VdbUnitItem item : itemList) {
            TreeItem treeItem = new TreeItem();
            treeItem.setId(item.getId());
            treeItem.setText(item.getName());
            items.add(treeItem);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }
}

