/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vdb.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vdb.remote.VdbPersonLevelByPersonRemote;
import com.zkteco.zkbiosecurity.vdb.service.VdbLevelService;
import com.zkteco.zkbiosecurity.vdb.service.VdbPersonLevelByPersonService;
import com.zkteco.zkbiosecurity.vdb.vo.VdbPersonLevelByPersonItem;
import com.zkteco.zkbiosecurity.vdb.vo.VdbPersonLevelItem;
import com.zkteco.zkbiosecurity.vdb.vo.VdbPersonSelectLevelItem;
import java.io.File;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VdbPersonLevelByPersonController
extends ExportController
implements VdbPersonLevelByPersonRemote {
    @Autowired
    private VdbLevelService vdbLevelService;
    @Autowired
    private VdbPersonLevelByPersonService vdbPersonLevelByPersonService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Value(value="${security.session.timeout:1800}")
    private Long sessionTimeout;
    @Autowired
    private PersPersonService persPersonService;

    public ModelAndView index() {
        return new ModelAndView("vdb/personLevelByPerson/vdbPersonLevelByPerson");
    }

    @RequiresPermissions(value={"vdb:personLevelByPerson:refresh"})
    public DxGrid list(VdbPersonLevelByPersonItem condition) {
        Pager pager = this.vdbPersonLevelByPersonService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vdb:personLevelByPerson:refresh"})
    public DxGrid getPersonLevel(VdbPersonLevelItem condition) {
        Pager pager = this.vdbLevelService.loadPersonLevelPagerByPager(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid getPersonSelectLevel(VdbPersonSelectLevelItem condition) {
        if (StringUtils.isBlank((CharSequence)condition.getSelectId())) {
            condition.setSelectId("-1");
        }
        ArrayList<String> selectLevelIds = new ArrayList<String>(Arrays.asList(condition.getSelectId().split(",")));
        if (condition.getType().equals("noSelected")) {
            StringBuilder notInLevelId = new StringBuilder();
            notInLevelId.append(StringUtils.join(selectLevelIds, (String)","));
            if (StringUtils.isNotBlank((CharSequence)condition.getNotInId())) {
                notInLevelId.append(",").append(condition.getNotInId());
            }
            condition.setNotInId(notInLevelId.toString());
        } else if (condition.getType().equals("selected")) {
            condition.setInId(StringUtils.join(selectLevelIds, (String)","));
        }
        condition.setFilterId(condition.getPersonId());
        Pager pager = this.vdbLevelService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vdb:personLevelByPerson:addLevel"})
    @LogRequest(module="vdb_module", object="common_leftMenu_levelSetByPerson", opType="common_level_addPersonLevel", requestParams={"personPin", "levelNames"}, opContent="common_level_name")
    public ZKResultMsg addLevel(String personId, String levelIds) {
        if (StringUtils.isNotBlank((CharSequence)personId) && StringUtils.isNotBlank((CharSequence)levelIds)) {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
            String[] levelIdArray = levelIds.split(",");
            int total = levelIdArray.length;
            for (int i = 0; i < total; ++i) {
                boolean isSetToDev;
                this.vdbLevelService.addPersonLevel(personId, levelIdArray[i]);
                boolean bl = isSetToDev = this.vdbLevelService.getDeviceCountByLevelId(levelIdArray[i]) > 0L;
                if (isSetToDev) {
                    this.vdbLevelService.setPersonLevelToDev(levelIdArray[i], personId);
                }
                this.progressCache.setProcess(new ProcessBean(0, (int)((double)(i + 1) * 1.0 / (double)total * 100.0)));
            }
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"vdb:personLevelByPerson:addLevel"})
    @LogRequest(module="vdb_module", object="common_leftMenu_levelSetByPerson", opType="common_level_delPersonLevel", requestParams={"personPin", "levelNames"}, opContent="common_level_name")
    public ZKResultMsg delLevel(String personId, String levelIds) {
        if (StringUtils.isNotBlank((CharSequence)personId) && StringUtils.isNotBlank((CharSequence)levelIds)) {
            this.vdbLevelService.immeDelPersonLevel(levelIds, personId);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public void export(HttpServletRequest request, HttpServletResponse response) {
    }

    @RequiresPermissions(value={"vdb:personLevelByPerson:export"})
    @LogRequest(module="vdb_module", object="common_leftMenu_levelSetByPerson", opType="common_op_export", opContent="common_op_export")
    public void exportPersonLevel(HttpServletRequest request, HttpServletResponse response) {
        if (this.isNeedValid("pwd")) {
            try {
                String loginPwd = this.request.getParameter("loginPwd");
                boolean ret = this.vdbLevelService.verifyLoginPwd(request.getSession().getId(), loginPwd);
                if (!ret) {
                    throw new ZKBusinessException("auth_user_pwdIncorrect");
                }
            }
            catch (ZKBusinessException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
            }
        }
        String personIds = request.getParameter("personIds");
        VdbPersonLevelItem vdbPersonLevelItem = new VdbPersonLevelItem();
        vdbPersonLevelItem.setPersonIdIn(personIds);
        List accPersonLevelItemList = this.vdbPersonLevelByPersonService.getExportItemList(vdbPersonLevelItem, this.getBeginIndex(), this.getEndIndex());
        if (Objects.isNull(accPersonLevelItemList) || accPersonLevelItemList.isEmpty()) {
            this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)("export-result:" + request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
            throw ZKBusinessException.warnException((String)"common_report_dataSourceNull", (Object[])new Object[0]);
        }
        String reportType = request.getParameter("reportType");
        String jsonColumn = request.getParameter("jsonColumn");
        String fileNamePrefix = request.getParameter("tableNameParam");
        List personIdList = StrUtil.strToList((String)personIds);
        try {
            boolean isMSIE;
            List exportPersonLevelItemList = null;
            String filePath = ClassUtil.getRootPath() + "/" + FileUtils.systemFilePath + "/" + "vdb" + "/" + "tempPersonLevel" + "/";
            File file = new File(filePath);
            if (!file.exists()) {
                file.mkdirs();
            }
            Map personIdAndPinMap = this.persPersonService.getPinsByPersonIds((Collection)personIdList);
            for (String personId : personIdList) {
                VdbPersonLevelItem personLevelItem = new VdbPersonLevelItem();
                personLevelItem.setPersonId(personId);
                exportPersonLevelItemList = this.vdbPersonLevelByPersonService.getExportItemList(personLevelItem, this.getBeginIndex(), this.getEndIndex());
                if (!Objects.nonNull(exportPersonLevelItemList) || exportPersonLevelItemList.isEmpty()) continue;
                String fileName = (String)personIdAndPinMap.get(personId) + "." + "xls";
                ExcelUtil.generateExcel((List)exportPersonLevelItemList, VdbPersonLevelItem.class, (String)jsonColumn, (String)fileName, (String)reportType, (String)filePath, null);
            }
            String agent = request.getHeader("User-Agent");
            boolean bl = isMSIE = agent != null && (agent.indexOf("MSIE") != -1 || agent.indexOf("Trident") != -1);
            if (isMSIE) {
                fileNamePrefix = URLEncoder.encode(fileNamePrefix, "UTF-8");
                fileNamePrefix = fileNamePrefix.replaceAll("\\+", " ");
            } else {
                fileNamePrefix = new String(fileNamePrefix.getBytes("UTF-8"), "ISO-8859-1");
            }
            if (request.getHeader("User-Agent") != null && request.getHeader("User-Agent").indexOf("Edge") != -1) {
                fileNamePrefix = fileNamePrefix.replaceAll(" ", "%20");
                fileNamePrefix = URLEncoder.encode(fileNamePrefix, "ISO-8859-1");
                fileNamePrefix = fileNamePrefix.replace("%2520", " ");
            }
            String tempPath = filePath + "/" + fileNamePrefix + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".zip";
            File excelFile = new File(filePath);
            File[] excelFiles = excelFile.listFiles();
            if (StringUtils.isNotBlank((CharSequence)request.getParameter("encryptPassword"))) {
                ArrayList<File> files = new ArrayList<File>();
                files.addAll(Arrays.asList(excelFiles));
                FileUtil.fileEncryptZip((String)tempPath, files, (String)request.getParameter("encryptPassword"), (HttpServletRequest)request, (HttpServletResponse)response);
            } else {
                response = FileUtil.downLoadFiles((String)tempPath, (File[])excelFiles, (HttpServletRequest)request, (HttpServletResponse)response);
            }
            response.flushBuffer();
            File zipTempFile = new File(tempPath);
            if (zipTempFile.exists()) {
                zipTempFile.delete();
            }
            FileUtils.deleteDirectory((String)filePath);
        }
        catch (Exception e) {
            this.log.error(fileNamePrefix + " export error", (Throwable)e);
            response.setHeader("Content-Disposition", "");
            response.setContentType("application/json");
            throw new ZKBusinessException("common_report_exportFaild");
        }
        finally {
            this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)("export-result:" + request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
        }
    }

    @RequiresPermissions(value={"vdb:personLevelByPerson:sync"})
    @LogRequest(module="vdb_module", object="common_leftMenu_levelSetByPerson", opType="common_dev_synchronize", opContent="common_dev_synchronize", requestParams={"personPins"})
    public ZKResultMsg syncPersonLevel(String personIds) {
        if (StringUtils.isNotBlank((CharSequence)personIds)) {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
            return this.vdbPersonLevelByPersonService.syncPersonLevel(this.request.getSession().getId(), personIds);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

