/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vdb.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vdb.remote.VdbPersonLevelByLevelRemote;
import com.zkteco.zkbiosecurity.vdb.service.VdbLevelService;
import com.zkteco.zkbiosecurity.vdb.service.VdbPersonLevelByLevelService;
import com.zkteco.zkbiosecurity.vdb.service.VdbPersonService;
import com.zkteco.zkbiosecurity.vdb.vo.VdbLevelPersonItem;
import com.zkteco.zkbiosecurity.vdb.vo.VdbPersonLevelByLevelExportItem;
import com.zkteco.zkbiosecurity.vdb.vo.VdbPersonLevelByLevelItem;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VdbPersonLevelByLevelController
extends ExportController
implements VdbPersonLevelByLevelRemote {
    private Logger logger = LoggerFactory.getLogger(VdbPersonLevelByLevelController.class);
    @Autowired
    private VdbPersonLevelByLevelService vdbPersonLevelByLevelService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private VdbPersonService vdbPersonService;
    @Autowired
    private VdbLevelService vdbLevelService;

    @RequiresPermissions(value={"vdb:personLevelByLevel"})
    public ModelAndView index() {
        return new ModelAndView("vdb/personLevelByLevel/vdbPersonLevelByLevel");
    }

    @RequiresPermissions(value={"vdb:personLevelByLevel", "vdb:personLevelByLevel:refresh"})
    public DxGrid list(VdbPersonLevelByLevelItem condition) {
        Pager pager = this.vdbPersonLevelByLevelService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid getLevelPerson(VdbLevelPersonItem condition) {
        Pager pager = this.vdbPersonService.getLevelPersonItemsByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vdb:personLevelByLevel:addPerson"})
    @LogRequest(module="vdb_module", object="common_leftMenu_levelSetByLevel", opType="pers_common_addPerson", requestParams={"levelName", "personPins"}, opContent="pers_person_pin")
    public ZKResultMsg addPerson(String levelId, String personIds, String buildingIds, String unitIds) {
        String clientId = this.request.getParameter("clientId");
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
        if (StringUtils.isNotBlank((CharSequence)buildingIds)) {
            personIds = this.vdbPersonService.getPersonIdsByBuildingIds(buildingIds);
        } else if (StringUtils.isNotBlank((CharSequence)unitIds)) {
            personIds = this.vdbPersonService.getPersonIdsByUnitIds(unitIds);
        }
        if (StringUtils.isNotBlank((CharSequence)personIds)) {
            ArrayList tempPersonIds = new ArrayList();
            tempPersonIds.addAll(StrUtil.strToList((String)personIds));
            List existPersonIds = this.vdbLevelService.getPersonIdsByLevelId(levelId);
            if (existPersonIds != null && existPersonIds.size() > 0) {
                tempPersonIds.removeAll(existPersonIds);
            }
            String string = personIds = tempPersonIds.size() > 0 ? StringUtils.join(tempPersonIds, (String)",") : "";
        }
        if (StringUtils.isNotBlank((CharSequence)personIds) && StringUtils.isNotBlank((CharSequence)levelId)) {
            try {
                List personArrayIds = this.vdbLevelService.splitPersonIds(personIds, 500);
                boolean isSetToDev = this.vdbLevelService.getDeviceCountByLevelId(levelId) > 0L;
                int[] currentCount = new int[]{0};
                int[] totalCount = new int[]{personArrayIds.size()};
                personArrayIds.parallelStream().forEach(personArrayId -> {
                    this.vdbLevelService.addLevelPerson(personArrayId, levelId);
                    if (isSetToDev) {
                        this.vdbLevelService.setPersonLevelToDev(levelId, personArrayId);
                    }
                    currentCount[0] = currentCount[0] + 1;
                    this.progressCache.setProcess(new ProcessBean(0, (int)((double)currentCount[0] * 100.0 / (double)totalCount[0])), clientId);
                });
            }
            catch (Exception e) {
                this.logger.error("addPerson with level error", (Throwable)e);
            }
        }
        this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"vdb:personLevelByLevel:delPerson"})
    @LogRequest(module="vdb_module", object="common_leftMenu_levelSetByLevel", opType="pers_common_delPerson", requestParams={"levelName", "personPins"}, opContent="pers_person_pin")
    public ZKResultMsg delPerson(String levelId, String personIds) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)levelId) && StringUtils.isNotBlank((CharSequence)personIds)) {
            zkResultMsg = this.vdbPersonLevelByLevelService.delPerson(levelId, personIds);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public void export(HttpServletRequest request, HttpServletResponse response) {
    }

    @LogRequest(module="vdb_module", object="common_leftMenu_levelSetByLevel", opType="vdb_level_exportLevelPerson", opContent="vdb_level_exportLevelPerson")
    @RequiresPermissions(value={"vdb:personLevelByLevel:export"})
    public void exportLevelPerson(HttpServletRequest request, HttpServletResponse response) {
        if (this.isNeedValid("pwd")) {
            try {
                String loginPwd = this.request.getParameter("loginPwd");
                boolean ret = this.vdbLevelService.verifyLoginPwd(request.getSession().getId(), loginPwd);
                if (!ret) {
                    throw new ZKBusinessException("auth_user_pwdIncorrect");
                }
            }
            catch (ZKBusinessException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
            }
        }
        String levelIds = request.getParameter("levelIds");
        VdbPersonLevelByLevelExportItem vdbLevelPersonItem = new VdbPersonLevelByLevelExportItem();
        vdbLevelPersonItem.setLevelIdsIn(levelIds);
        List vdbLevelPersonItemList = this.vdbPersonService.getExportLevelPersonItemListByAuthFilter(vdbLevelPersonItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(vdbLevelPersonItemList, VdbPersonLevelByLevelExportItem.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LogRequest(module="vdb_module", object="common_leftMenu_levelSetByLevel", opType="vdb_level_importLevelPerson", opContent="vdb_level_importLevelPerson")
    @RequiresPermissions(value={"vdb:personLevelByLevel:import"})
    public ZKResultMsg importLevelPerson(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0]) + "<br/>"));
            List itemList = ExcelUtil.excelImport((InputStream)upload.getInputStream(), VdbPersonLevelByLevelExportItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0]) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.vdbLevelService.importVdbPersonData(itemList));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import Person Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }
}

