/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vdb.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vdb.remote.VdbPersonRemote;
import com.zkteco.zkbiosecurity.vdb.service.VdbLevelService;
import com.zkteco.zkbiosecurity.vdb.service.VdbPersonService;
import com.zkteco.zkbiosecurity.vdb.vo.VdbSelectPersonItem;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VdbPersonController
extends BaseController
implements VdbPersonRemote {
    @Autowired
    private VdbPersonService vdbPersonService;
    @Autowired
    private VdbLevelService vdbLevelService;

    @RequiresPermissions(value={"pers:person:vdbEdit"})
    public ModelAndView edit(String personId) {
        if (StringUtils.isNotBlank((CharSequence)personId)) {
            this.request.setAttribute("item", (Object)this.vdbPersonService.getItemByPersonId(personId));
            this.request.setAttribute("tempList", (Object)this.vdbLevelService.getLevelByPersonId(personId));
        }
        return new ModelAndView("vdb/person/editVdbPerson");
    }

    public DxGrid selectLevelPersonList(VdbSelectPersonItem condition) {
        Pager pager = new Pager();
        if (condition.getType().equals("noSelected")) {
            pager = this.vdbPersonService.getNoExistPerson(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg getPersonCountByBuilding(String buildingIds) {
        long personCount = this.vdbPersonService.getPersonCountByBuilding(buildingIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)personCount));
    }

    public ZKResultMsg getPersonCountByUnit(String unitIds) {
        long personCount = this.vdbPersonService.getPersonCountByUnit(unitIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)personCount));
    }
}

