/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vdb.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vdb.remote.VdbLevelRemote;
import com.zkteco.zkbiosecurity.vdb.service.VdbBuildingService;
import com.zkteco.zkbiosecurity.vdb.service.VdbDeviceService;
import com.zkteco.zkbiosecurity.vdb.service.VdbLevelService;
import com.zkteco.zkbiosecurity.vdb.vo.VdbLevelDeviceExportItem;
import com.zkteco.zkbiosecurity.vdb.vo.VdbLevelDeviceItem;
import com.zkteco.zkbiosecurity.vdb.vo.VdbLevelItem;
import com.zkteco.zkbiosecurity.vdb.vo.VdbLevelSelectDeviceItem;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VdbLevelController
extends ExportController
implements VdbLevelRemote {
    @Autowired
    private VdbLevelService vdbLevelService;
    @Autowired
    private VdbDeviceService vdbDeviceService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private VdbBuildingService vdbBuildingService;

    @RequiresPermissions(value={"vdb:level"})
    public ModelAndView index() {
        return new ModelAndView("vdb/level/vdbLevel");
    }

    @RequiresPermissions(value={"vdb:level:add", "vdb:level:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            VdbLevelItem item = this.vdbLevelService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("vdb/level/editVdbLevel");
    }

    @RequiresPermissions(value={"vdb:level:add", "vdb:level:edit"})
    @LogRequest(module="vdb_module", object="vdb_leftMenu_accessLevel", opType="common_op_edit", requestParams={"name"}, opContent="common_level_name")
    public ZKResultMsg save(VdbLevelItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.vdbLevelService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"vdb:level:refresh"})
    public DxGrid list(VdbLevelItem condition) {
        Pager pager = this.vdbLevelService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vdb:level:del"})
    @LogRequest(module="vdb_module", object="vdb_leftMenu_accessLevel", opType="common_op_del", requestParams={"names"}, opContent="common_level_name")
    public ZKResultMsg del(String ids) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            ArrayList<String> levelIdList = new ArrayList<String>(Arrays.asList(ids.split(",")));
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
            ArrayList tempPersonIdList = new ArrayList();
            int levelSize = levelIdList.size();
            for (int i = 0; i < levelSize; ++i) {
                int total = (int)((double)i * 100.0 / (double)levelSize);
                total = total == 100 ? 99 : total;
                List personIdList = this.vdbLevelService.getPersonIdsByLevelId((String)levelIdList.get(i));
                if (personIdList != null && personIdList.size() > 0) {
                    List deviceIdList = this.vdbLevelService.getDevIdsByLevelId((String)levelIdList.get(i));
                    for (String deviceId : deviceIdList) {
                        int personSize = personIdList.size();
                        for (int j = 0; j < personSize; ++j) {
                            tempPersonIdList.add(personIdList.get(j));
                            if (tempPersonIdList.size() % 500 != 0) continue;
                            this.vdbLevelService.immeDelLevel(deviceId, (String)levelIdList.get(i), tempPersonIdList);
                            this.progressCache.setProcess(new ProcessBean((int)((double)j * 100.0 / (double)personSize), total, "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0])));
                            tempPersonIdList = new ArrayList();
                        }
                        if (tempPersonIdList.size() <= 0) continue;
                        this.vdbLevelService.immeDelLevel(deviceId, (String)levelIdList.get(i), tempPersonIdList);
                        this.progressCache.setProcess(new ProcessBean(100, total, "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0])));
                    }
                    this.vdbLevelService.delLevelDeviceByParams((String)levelIdList.get(i), deviceIdList);
                    continue;
                }
                this.vdbLevelService.delLevelDeviceByLevelId((String)levelIdList.get(i));
            }
            this.vdbLevelService.deleteByIds(ids);
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"vdb:level:export"})
    @LogRequest(module="vdb_module", object="vdb_leftMenu_level", opType="vdb_level_exportLevel", opContent="vdb_level_exportLevel")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        VdbLevelItem vdbLevelItem = new VdbLevelItem();
        this.setConditionValue((BaseItem)vdbLevelItem);
        List accLevelItemList = this.vdbLevelService.getExportLevelItemList(vdbLevelItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(accLevelItemList, VdbLevelItem.class);
    }

    public String isExistName(String name) {
        VdbLevelItem item = this.vdbLevelService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    public DxGrid selectDeviceList(VdbLevelSelectDeviceItem condition) {
        String levelId = condition.getLevelId();
        if (StringUtils.isBlank((CharSequence)condition.getSelectId())) {
            condition.setSelectId("-1");
        }
        if (condition.getType().equals("noSelected")) {
            condition.setSelectDeviceIdsNotIn(condition.getSelectId());
        } else if (condition.getType().equals("selected")) {
            condition.setSelectDeviceIdsIn(condition.getSelectId());
        }
        condition.setFilterId(levelId);
        Pager pager = this.vdbDeviceService.getSelectPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vdb:level:addDevice"})
    @LogRequest(module="vdb_module", object="vdb_leftMenu_accessLevel", opType="vdb_level_addDevice", requestParams={"levelName", "deviceNames"}, opContent="common_level_name")
    public ZKResultMsg addDevice(String levelId, String deviceIds) {
        if (StringUtils.isNotBlank((CharSequence)levelId) && StringUtils.isNotBlank((CharSequence)deviceIds)) {
            String clientId = this.request.getParameter("clientId");
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
            this.vdbLevelService.addLevelDevice(deviceIds, levelId);
            List personIdList = this.vdbLevelService.getPersonIdsByLevelId(levelId);
            if (personIdList != null && personIdList.size() > 0) {
                List personArrayIds = this.vdbLevelService.splitPersonIds(StringUtils.join((Iterable)personIdList, (String)","), 500);
                int[] currentCount = new int[]{0};
                int[] totalCount = new int[]{personArrayIds.size()};
                personArrayIds.parallelStream().forEach(personArrayId -> {
                    this.vdbLevelService.setPersonToDevice(deviceIds, personArrayId);
                    currentCount[0] = currentCount[0] + 1;
                    this.progressCache.setProcess(new ProcessBean(0, (int)((double)currentCount[0] * 100.0 / (double)totalCount[0])), clientId);
                });
            }
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"vdb:level:refresh"})
    public DxGrid deviceList(VdbLevelDeviceItem condition) {
        Pager pager = this.vdbDeviceService.vdbLevelDeviceList(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vdb:level:delDevice"})
    @LogRequest(module="vdb_module", object="vdb_leftMenu_accessLevel", opType="vdb_level_delDevice", requestParams={"levelName", "deviceNames"}, opContent="common_level_name")
    public ZKResultMsg delDevice(String levelId, String deviceIds) {
        if (StringUtils.isNotBlank((CharSequence)levelId) && StringUtils.isNotBlank((CharSequence)deviceIds)) {
            ArrayList<String> deviceIdList = new ArrayList<String>(Arrays.asList(deviceIds.split(",")));
            String clientId = this.request.getParameter("clientId");
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
            this.vdbLevelService.delLevelDeviceByParams(levelId, deviceIdList);
            List personIdList = this.vdbLevelService.getPersonIdsByLevelId(levelId);
            if (personIdList != null && personIdList.size() > 0) {
                List personArrayIds = this.vdbLevelService.splitPersonIds(StringUtils.join((Iterable)personIdList, (String)","), 500);
                int[] currentCount = new int[]{0};
                int[] totalCount = new int[]{personArrayIds.size()};
                personArrayIds.parallelStream().forEach(personArrayId -> {
                    this.vdbLevelService.delPersonLevelFromDevice(levelId, StringUtils.join((Iterable)deviceIdList, (String)","), StrUtil.strToList((String)personArrayId));
                    currentCount[0] = currentCount[0] + 1;
                    this.progressCache.setProcess(new ProcessBean(0, (int)((double)currentCount[0] * 100.0 / (double)totalCount[0])), clientId);
                });
            }
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @LogRequest(module="vdb_module", object="vdb_leftMenu_accessLevel", opType="vdb_level_exportLevelDevice", opContent="vdb_level_exportLevelDevice")
    @RequiresPermissions(value={"vdb:levelDevice:export"})
    public void exportLevelDevice(HttpServletRequest request, HttpServletResponse response) {
        if (this.isNeedValid("pwd")) {
            try {
                String loginPwd = this.request.getParameter("loginPwd");
                boolean ret = this.vdbLevelService.verifyLoginPwd(request.getSession().getId(), loginPwd);
                if (!ret) {
                    throw new ZKBusinessException("auth_user_pwdIncorrect");
                }
            }
            catch (ZKBusinessException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
            }
        }
        String levelIds = request.getParameter("levelIds");
        VdbLevelDeviceExportItem vdbLevelDeviceExportItem = new VdbLevelDeviceExportItem();
        vdbLevelDeviceExportItem.setLevelIdsIn(levelIds);
        String userId = this.vdbBuildingService.getUserIdBySessionId(request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            vdbLevelDeviceExportItem.setUserId(userId);
        }
        List accLevelDoorItemList = this.vdbDeviceService.getExportLevelDeviceItemList(vdbLevelDeviceExportItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(accLevelDoorItemList, VdbLevelDeviceExportItem.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LogRequest(module="vdb_module", object="vdb_leftMenu_accessLevel", opType="vdb_level_importLevel", opContent="vdb_level_importLevel")
    @RequiresPermissions(value={"vdb:level:import"})
    public ZKResultMsg importExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0]) + "<br/>"));
            List itemList = ExcelUtil.excelImport((InputStream)upload.getInputStream(), VdbLevelItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0]) + "<br/>"));
            boolean updateExistData = false;
            String isupdateExistData = this.request.getParameter("updateExistData");
            if ("1".equals(isupdateExistData)) {
                updateExistData = true;
            }
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.vdbLevelService.importLevelData(itemList, updateExistData));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import VdbLevel Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LogRequest(module="vdb_module", object="vdb_leftMenu_accessLevel", opType="vdb_level_importLevelDevice", opContent="vdb_level_importLevelDevice")
    @RequiresPermissions(value={"vdb:levelDevice:import"})
    public ZKResultMsg importLevelDevice(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0]) + "<br/>"));
            List itemList = ExcelUtil.excelImport((InputStream)upload.getInputStream(), VdbLevelDeviceExportItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0]) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.vdbLevelService.importLevelDeviceData(itemList));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import VdbLevelDevice Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }
}

