/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vdb.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vdb.constants.VdbConstants;
import com.zkteco.zkbiosecurity.vdb.remote.VdbDeviceRemote;
import com.zkteco.zkbiosecurity.vdb.service.VdbBuildingService;
import com.zkteco.zkbiosecurity.vdb.service.VdbDeviceService;
import com.zkteco.zkbiosecurity.vdb.vo.VdbDeviceItem;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VdbDeviceController
extends ExportController
implements VdbDeviceRemote {
    @Autowired
    private VdbDeviceService vdbDeviceService;
    @Autowired
    private VdbBuildingService vdbBuildingService;

    @RequiresPermissions(value={"vdb:device"})
    public ModelAndView index() {
        return new ModelAndView("vdb/device/vdbDevice");
    }

    @RequiresPermissions(value={"vdb:device:add", "vdb:device:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            VdbDeviceItem item = this.vdbDeviceService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("vdb/device/editVdbDevice");
    }

    @RequiresPermissions(value={"vdb:device:add", "vdb:device:edit"})
    @LogRequest(module="vdb_module", object="vdb_leftMenu_device", opType="common_op_edit", requestParams={"name"}, opContent="common_dev_name")
    public ZKResultMsg save(VdbDeviceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.vdbDeviceService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"vdb:device:refresh"})
    public DxGrid list(VdbDeviceItem condition) {
        Pager pager = this.vdbDeviceService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vdb:device:del"})
    public ZKResultMsg del(String ids) {
        this.vdbDeviceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @LogRequest(module="vdb_module", object="vdb_leftMenu_device", opType="common_op_export", opContent="common_op_export")
    @RequiresPermissions(value={"vdb:device:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        VdbDeviceItem vdbDeviceItem = new VdbDeviceItem();
        this.setConditionValue((BaseItem)vdbDeviceItem);
        String userId = this.vdbBuildingService.getUserIdBySessionId(request.getSession().getId());
        vdbDeviceItem.setUserId(userId);
        List vdbDeviceItems = this.vdbDeviceService.getExportItemList(vdbDeviceItem, this.getBeginIndex(), this.getEndIndex());
        vdbDeviceItems.stream().forEach(item -> item.setDeviceType((String)VdbConstants.VDB_DEVICE_TYPE.get(item.getDeviceType())));
        this.excelExport(vdbDeviceItems, VdbDeviceItem.class);
    }

    public boolean isExistName(String name) {
        return this.vdbDeviceService.isExistName(name);
    }

    public boolean isExistIpAddress(String ipAddress) {
        return this.vdbDeviceService.isExistIpAddress(ipAddress);
    }

    public boolean checkDeviceSupportType(VdbDeviceItem condition) {
        return this.vdbDeviceService.checkDeviceSupportType(condition);
    }

    public boolean isExistDeviceNo(VdbDeviceItem condition) {
        VdbDeviceItem item = this.vdbDeviceService.isExistDeviceNo(condition);
        return item == null;
    }

    public boolean isExistRoomNo(String unitId, String roomNo) {
        VdbDeviceItem item = this.vdbDeviceService.isExistRoomNo(unitId, roomNo);
        return item == null;
    }

    @RequiresPermissions(value={"vdb:device:rebootDevice"})
    @LogRequest(module="vdb_module", object="common_leftMenu_device", opType="common_dev_reboot", requestParams={"name"}, opContent="common_dev_name")
    public ZKResultMsg rebootDevice(String ids) {
        String offline;
        if (StringUtils.isNotBlank((CharSequence)ids) && StringUtils.isNotBlank((CharSequence)(offline = this.vdbDeviceService.rebootDevice(ids)))) {
            offline = offline.substring(0, offline.length() - 1);
            throw new ZKBusinessException(offline);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"vdb:device:syncTime"})
    @LogRequest(module="vdb_module", object="common_leftMenu_device", opType="common_dev_syncTime", requestParams={"name"}, opContent="common_dev_name")
    public ZKResultMsg syncTime(String ids) {
        String offline;
        if (StringUtils.isNotBlank((CharSequence)ids) && StringUtils.isNotBlank((CharSequence)(offline = this.vdbDeviceService.syncTime(ids)))) {
            offline = offline.substring(0, offline.length() - 1);
            throw new ZKBusinessException(offline);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"vdb:device:syncAllData"})
    public ModelAndView getDevIdsBySyncData(String ids, String type) {
        if (type != null && !type.isEmpty()) {
            List list = this.vdbDeviceService.getItemByIds(ids);
            StringBuffer devName = new StringBuffer("");
            VdbDeviceItem dev = null;
            StringBuffer retIds = new StringBuffer();
            HashMap<String, StringBuffer> devNameMap = new HashMap<String, StringBuffer>();
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                dev = (VdbDeviceItem)list.get(i);
                String devType = dev.getDeviceType();
                retIds.append(dev.getId()).append(",");
                String devTypeName = (String)VdbConstants.VDB_DEVICE_TYPE.get(devType);
                if (devNameMap.containsKey(devTypeName)) {
                    ((StringBuffer)devNameMap.get(devTypeName)).append(dev.getName() + "&" + dev.getId() + ",");
                    continue;
                }
                StringBuffer devNameBuf = new StringBuffer(devTypeName + "-" + I18nUtil.i18nCode((String)((String)VdbConstants.VDB_DEVICE_TYPE.get(devType)), (Object[])new Object[0]) + ":" + dev.getName() + "&" + dev.getId() + ",");
                devNameMap.put(devTypeName, devNameBuf);
            }
            for (StringBuffer nameBuf : devNameMap.values()) {
                devName.append(nameBuf.substring(0, nameBuf.length() - 1) + ";");
            }
            this.request.setAttribute("devIds", retIds.length() > 0 ? retIds.substring(0, retIds.length() - 1) : null);
            this.request.setAttribute("devicesName", devName.length() > 0 ? devName.substring(0, devName.length() - 1) : null);
            if ("syncAllData".equals(type)) {
                return new ModelAndView("vdb/device/opVdbSyncAllData");
            }
        }
        return null;
    }

    public ZKResultMsg validDeviceCountByType(String devType) {
        this.vdbDeviceService.validDeviceCountByType(devType);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg isSupportSyncPersonData(String devIds) {
        ZKResultMsg zkResultMsg = ZKResultMsg.successMsg();
        VdbDeviceItem dev = this.vdbDeviceService.getItemById(devIds);
        if (dev != null && ("2".equals(dev.getDeviceType()) || "3".equals(dev.getDeviceType()))) {
            zkResultMsg.setRet("400");
            zkResultMsg.setMsg(I18nUtil.i18nCode((String)"common_dev_devNotSupportFunction", (Object[])new Object[0]));
        }
        return zkResultMsg;
    }

    @RequiresPermissions(value={"vdb:device:uploadRecords"})
    @LogRequest(module="vdb_module", object="common_leftMenu_device", opType="vdb_records_upload", requestParams={"name"}, opContent="common_dev_name")
    public ZKResultMsg getUploadRecords(String ids) {
        String offline;
        if (StringUtils.isNotBlank((CharSequence)ids) && StringUtils.isNotBlank((CharSequence)(offline = this.vdbDeviceService.uploadRecords(ids)))) {
            offline = offline.substring(0, offline.length() - 1);
            throw new ZKBusinessException(offline);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"vdb:device:uploadRecords"})
    @LogRequest(module="vdb_module", object="common_leftMenu_device", opType="vdb_device_syncPerson", requestParams={"name"}, opContent="common_dev_name")
    public ZKResultMsg syncPersonData(String ids) {
        String offline;
        if (StringUtils.isNotBlank((CharSequence)ids) && StringUtils.isNotBlank((CharSequence)(offline = this.vdbDeviceService.syncPersonData(ids)))) {
            offline = offline.substring(0, offline.length() - 1);
            throw new ZKBusinessException(offline);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

