/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vdb.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vdb.remote.VdbCallRecordsRemote;
import com.zkteco.zkbiosecurity.vdb.service.VdbBuildingService;
import com.zkteco.zkbiosecurity.vdb.service.VdbCallRecordsService;
import com.zkteco.zkbiosecurity.vdb.service.VdbDeviceService;
import com.zkteco.zkbiosecurity.vdb.vo.VdbCallRecordsItem;
import com.zkteco.zkbiosecurity.vdb.vo.VdbRecordsSelectDeviceItem;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VdbCallRecordsController
extends ExportController
implements VdbCallRecordsRemote {
    @Autowired
    private VdbCallRecordsService vdbCallRecordsService;
    @Autowired
    private VdbDeviceService vdbDeviceService;
    @Autowired
    private VdbBuildingService vdbBuildingService;

    @RequiresPermissions(value={"vdb:callRecords"})
    public ModelAndView index() {
        return new ModelAndView("vdb/callRecords/vdbCallRecords");
    }

    @RequiresPermissions(value={"vdb:callRecords:refresh"})
    public DxGrid list(VdbCallRecordsItem condition) {
        Pager pager = this.vdbCallRecordsService.loadRecordsByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @LogRequest(module="vdb_module", object="vdb_leftMenu_callRecords", opType="vdb_records_upload", requestParams={"deviceName"}, opContent="common_dev_name")
    @RequiresPermissions(value={"vdb:callRecords:upload"})
    public ZKResultMsg uploadRecords() {
        String selectDeviceId = this.request.getParameter("selectDeviceId");
        if (StringUtils.isNotBlank((CharSequence)selectDeviceId)) {
            this.vdbCallRecordsService.uploadRecordsByDeviceId(selectDeviceId);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"vdb:callRecords:export"})
    @LogRequest(module="vdb_module", object="vdb_leftMenu_callRecords", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        VdbCallRecordsItem vdbCallRecordsItem = new VdbCallRecordsItem();
        this.setConditionValue((BaseItem)vdbCallRecordsItem);
        String userId = this.vdbBuildingService.getUserIdBySessionId(request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            vdbCallRecordsItem.setAreaNameByUserId(userId);
        }
        List itemList = this.vdbCallRecordsService.getItemData(VdbCallRecordsItem.class, vdbCallRecordsItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, VdbCallRecordsItem.class);
    }

    public DxGrid selectDeviceList(VdbRecordsSelectDeviceItem condition) {
        condition.setDeviceType("3");
        if (StringUtils.isBlank((CharSequence)condition.getSelectId())) {
            condition.setSelectId("-1");
        }
        if (condition.getType().equals("noSelected")) {
            condition.setSelectDeviceIdsNotIn(condition.getSelectId());
        } else if (condition.getType().equals("selected")) {
            condition.setSelectDeviceIdsIn(condition.getSelectId());
        }
        Pager pager = this.vdbDeviceService.getSelectDevPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }
}

