/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vdb.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vdb.remote.VdbBuildingRemote;
import com.zkteco.zkbiosecurity.vdb.service.VdbBuildingService;
import com.zkteco.zkbiosecurity.vdb.vo.VdbBuildingItem;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VdbBuildingController
extends ExportController
implements VdbBuildingRemote {
    @Autowired
    private VdbBuildingService vdbBuildingService;
    @Autowired
    private ProgressCache progressCache;

    @RequiresPermissions(value={"vdb:building"})
    public ModelAndView index() {
        return new ModelAndView("vdb/building/vdbBuilding");
    }

    @RequiresPermissions(value={"vdb:building:add", "vdb:building:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            VdbBuildingItem item = this.vdbBuildingService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("vdb/building/editVdbBuilding");
    }

    @RequiresPermissions(value={"vdb:building:add", "vdb:building:edit"})
    @LogRequest(module="vdb_module", object="vdb_leftMenu_building", opType="common_op_edit", requestParams={"name"}, opContent="vdb_building_name")
    public ZKResultMsg save(VdbBuildingItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.vdbBuildingService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"vdb:building:refresh"})
    public DxGrid list(VdbBuildingItem condition) {
        Pager pager = this.vdbBuildingService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vdb:building:del"})
    @LogRequest(module="vdb_module", object="vdb_leftMenu_building", opType="common_op_del", requestParams={"names"}, opContent="vdb_building_name")
    public ZKResultMsg del(String ids) {
        this.vdbBuildingService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String isExistName(String name) {
        VdbBuildingItem item = this.vdbBuildingService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    public ZKResultMsg getBuildingList() {
        String userId = this.vdbBuildingService.getUserIdBySessionId(this.request.getSession().getId());
        VdbBuildingItem item = new VdbBuildingItem();
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            item.setUserId(userId);
        }
        return new ZKResultMsg((Object)this.vdbBuildingService.getSelectListByCondition(item));
    }

    public boolean isExistBuildingNo(String authAreaId, String buildingNo, String id) {
        VdbBuildingItem item = new VdbBuildingItem();
        item.setBuildingNo(buildingNo);
        item.setAuthAreaId(authAreaId);
        item.setIdNotEq(id);
        item = this.vdbBuildingService.getItemByCondition(item);
        return item == null || item.getId().equals(id);
    }

    public ZKResultMsg getBuildingByAreaId(String areaId) {
        VdbBuildingItem item = new VdbBuildingItem();
        if (StringUtils.isNotBlank((CharSequence)areaId)) {
            item.setAuthAreaId(areaId);
        }
        return new ZKResultMsg((Object)this.vdbBuildingService.getSelectListByCondition(item));
    }

    @LogRequest(module="vdb_module", object="vdb_leftMenu_building", opType="common_op_export", opContent="common_op_export")
    @RequiresPermissions(value={"vdb:building:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        VdbBuildingItem vdbBuildingItem = new VdbBuildingItem();
        this.setConditionValue((BaseItem)vdbBuildingItem);
        String userId = this.vdbBuildingService.getUserIdBySessionId(request.getSession().getId());
        vdbBuildingItem.setUserId(userId);
        List vdbBuildingItemList = this.vdbBuildingService.getExportBulidingItemList(vdbBuildingItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(vdbBuildingItemList, VdbBuildingItem.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"vdb:building:import"})
    @LogRequest(module="vdb_module", object="vdb_leftMenu_building", opType="common_op_import", opContent="common_op_import")
    public ZKResultMsg importExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0]) + "<br/>"));
            List itemList = ExcelUtil.excelImport((InputStream)upload.getInputStream(), VdbBuildingItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0]) + "<br/>"));
            boolean updateExistData = false;
            String isupdateExistData = this.request.getParameter("updateExistData");
            if ("1".equals(isupdateExistData)) {
                updateExistData = true;
            }
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.vdbBuildingService.importBuildingData(itemList, updateExistData));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)e).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import VdbBuilding Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    public TreeItem getBuildingTree() {
        List itemList = this.vdbBuildingService.loadItemsByAuthFilter(this.request.getSession().getId(), new VdbBuildingItem());
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        for (VdbBuildingItem item : itemList) {
            TreeItem treeItem = new TreeItem();
            treeItem.setId(item.getId());
            treeItem.setText(item.getName());
            items.add(treeItem);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }
}

