/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.annotation.Where;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="POS_TRANSACTIONCARD t ")
@Where(after="AND t.HIDE_COLUMN = 7 ")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600, operates={})
public class PosTransactionRecordCardCostItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID", equalTag="=")
    @GridColumn(checkbox=true, width="40", sort="na", show=false)
    private String id;
    @Column(name="t.PERSON_ID")
    @GridColumn(label="pos_transactionCard_personId", show=false)
    private String personId;
    @Column(name="t.PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="100", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}", i18n=true)
    private String personPin;
    @Column(name="t.PERSON_NAME")
    @GridColumn(label="pers_person_name", width="100", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @Column(name="t.PERSON_LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="80", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}", showExpression="#language!='zh_CN'")
    private String personLastName;
    @Column(name="t.DEPT_NAME")
    @GridColumn(label="pos_card_deptName", width="110")
    private String deptName;
    @Column(name="t.CARD", encryptConverter=true)
    @GridColumn(label="pos_card_card", width="85", encryptMode="${pers.cardNo.encryptMode}", encryptProp="${pers.cardNo.encryptProp}")
    private String card;
    @Column(name="t.SYS_CARD_NO")
    @GridColumn(label="pos_card_accountNum", width="85")
    private Integer sysCardNo;
    @Column(name="cast((t.MONEY + t.SUBMONEY) as decimal(18,2))")
    @GridColumn(label="pos_card_cost", width="105", format="0=0.0")
    private Double money;
    @Column(name="t.CHECK_TIME")
    @GridColumn(label="pos_card_changeTime", width="130")
    private Date checkTime;
    @Column(name="t.CREATER_NAME")
    @GridColumn(label="pos_card_creatOperator", width="78")
    private String creatOperator;
    @Condition(value="t.CREATE_TIME", equalTag=">=", toDate=true)
    private String opTimeBegin;
    @Condition(value="t.CREATE_TIME", equalTag="<=", toDate=true)
    private String opTimeEnd;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Column(name="t.HIDE_COLUMN")
    private Integer hideColumn;
    @Condition(value="(lower(t.PERSON_NAME) LIKE LOWER(''%{0}%'') OR lower(t.PERSON_LAST_NAME) LIKE LOWER(''%{0}%''))")
    private String likeName;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID = ''{0}'' )")
    private String userId;

    public PosTransactionRecordCardCostItem() {
    }

    public PosTransactionRecordCardCostItem(Boolean equals) {
        super(equals);
    }

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getCard() {
        return this.card;
    }

    public Integer getSysCardNo() {
        return this.sysCardNo;
    }

    public Double getMoney() {
        return this.money;
    }

    public Date getCheckTime() {
        return this.checkTime;
    }

    public String getCreatOperator() {
        return this.creatOperator;
    }

    public String getOpTimeBegin() {
        return this.opTimeBegin;
    }

    public String getOpTimeEnd() {
        return this.opTimeEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public Integer getHideColumn() {
        return this.hideColumn;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getUserId() {
        return this.userId;
    }

    public PosTransactionRecordCardCostItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosTransactionRecordCardCostItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PosTransactionRecordCardCostItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosTransactionRecordCardCostItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosTransactionRecordCardCostItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PosTransactionRecordCardCostItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PosTransactionRecordCardCostItem setCard(String card) {
        this.card = card;
        return this;
    }

    public PosTransactionRecordCardCostItem setSysCardNo(Integer sysCardNo) {
        this.sysCardNo = sysCardNo;
        return this;
    }

    public PosTransactionRecordCardCostItem setMoney(Double money) {
        this.money = money;
        return this;
    }

    public PosTransactionRecordCardCostItem setCheckTime(Date checkTime) {
        this.checkTime = checkTime;
        return this;
    }

    public PosTransactionRecordCardCostItem setCreatOperator(String creatOperator) {
        this.creatOperator = creatOperator;
        return this;
    }

    public PosTransactionRecordCardCostItem setOpTimeBegin(String opTimeBegin) {
        this.opTimeBegin = opTimeBegin;
        return this;
    }

    public PosTransactionRecordCardCostItem setOpTimeEnd(String opTimeEnd) {
        this.opTimeEnd = opTimeEnd;
        return this;
    }

    public PosTransactionRecordCardCostItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosTransactionRecordCardCostItem setHideColumn(Integer hideColumn) {
        this.hideColumn = hideColumn;
        return this;
    }

    public PosTransactionRecordCardCostItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PosTransactionRecordCardCostItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String toString() {
        return "PosTransactionRecordCardCostItem(id=" + this.getId() + ", personId=" + this.getPersonId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", deptName=" + this.getDeptName() + ", card=" + this.getCard() + ", sysCardNo=" + this.getSysCardNo() + ", money=" + this.getMoney() + ", checkTime=" + this.getCheckTime() + ", creatOperator=" + this.getCreatOperator() + ", opTimeBegin=" + this.getOpTimeBegin() + ", opTimeEnd=" + this.getOpTimeEnd() + ", inDeptId=" + this.getInDeptId() + ", hideColumn=" + this.getHideColumn() + ", likeName=" + this.getLikeName() + ", userId=" + this.getUserId() + ")";
    }
}

