/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="POS_CARDMANAGE t ")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600, operates={})
public class PosTransactionRecordCardBlanceItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID", equalTag="=")
    @GridColumn(checkbox=true, width="40", sort="na", show=false)
    private String id;
    @Column(name="t.PERSON_ID")
    @GridColumn(label="pos_transactionCard_personId", show=false)
    private String personId;
    @Column(name="t.PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="100", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}", i18n=true)
    private String personPin;
    @GridColumn(label="pers_person_name", width="100", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @GridColumn(label="pers_person_lastName", width="80", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}", showExpression="#language!='zh_CN'")
    private String personLastName;
    @Column(name="t.DEPT_NAME")
    @GridColumn(label="pos_card_deptName", width="110")
    private String deptName;
    @Column(name="t.CARD_NO", encryptConverter=true)
    @GridColumn(label="pos_card_card", width="120", encryptMode="${pers.cardNo.encryptMode}", encryptProp="${pers.cardNo.encryptProp}")
    private String cardNo;
    @Column(name="t.SYS_CARD_NO")
    @GridColumn(label="pos_card_accountNum", width="85")
    private Integer sysCardNo;
    @Column(name="t.CARD_STATUS")
    @GridColumn(label="pos_card_cardStatus", width="85", format="1=pos_card_valid,3=pos_op_lostCard,4=pos_card_pastDue,5=pos_card_stopUse")
    private String cardStatus;
    @Column(name="t.ISSUE_DATE")
    @GridColumn(label="pos_card_sendCardDate", width="210")
    private Date issueDate;
    @Column(name="cast((t.BALANCE + t.SUBBALANCE) as decimal(18,2))")
    @GridColumn(label="pos_card_blance", format="0=0.0")
    private Double balance;
    @Condition(value="t.ISSUE_DATE", equalTag=">=", toDate=true)
    private String opTimeBegin;
    @Condition(value="t.ISSUE_DATE", equalTag="<=", toDate=true)
    private String opTimeEnd;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="(lower(t.PERSON_NAME) LIKE LOWER(''%{0}%'') OR lower(t.PERSON_LAST_NAME) LIKE LOWER(''%{0}%''))")
    private String likeName;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID = ''{0}'' )")
    private String userId;

    public PosTransactionRecordCardBlanceItem() {
    }

    public PosTransactionRecordCardBlanceItem(Boolean equals) {
        super(equals);
    }

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public Integer getSysCardNo() {
        return this.sysCardNo;
    }

    public String getCardStatus() {
        return this.cardStatus;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public Double getBalance() {
        return this.balance;
    }

    public String getOpTimeBegin() {
        return this.opTimeBegin;
    }

    public String getOpTimeEnd() {
        return this.opTimeEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getUserId() {
        return this.userId;
    }

    public PosTransactionRecordCardBlanceItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosTransactionRecordCardBlanceItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PosTransactionRecordCardBlanceItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosTransactionRecordCardBlanceItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosTransactionRecordCardBlanceItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PosTransactionRecordCardBlanceItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PosTransactionRecordCardBlanceItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public PosTransactionRecordCardBlanceItem setSysCardNo(Integer sysCardNo) {
        this.sysCardNo = sysCardNo;
        return this;
    }

    public PosTransactionRecordCardBlanceItem setCardStatus(String cardStatus) {
        this.cardStatus = cardStatus;
        return this;
    }

    public PosTransactionRecordCardBlanceItem setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
        return this;
    }

    public PosTransactionRecordCardBlanceItem setBalance(Double balance) {
        this.balance = balance;
        return this;
    }

    public PosTransactionRecordCardBlanceItem setOpTimeBegin(String opTimeBegin) {
        this.opTimeBegin = opTimeBegin;
        return this;
    }

    public PosTransactionRecordCardBlanceItem setOpTimeEnd(String opTimeEnd) {
        this.opTimeEnd = opTimeEnd;
        return this;
    }

    public PosTransactionRecordCardBlanceItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosTransactionRecordCardBlanceItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PosTransactionRecordCardBlanceItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String toString() {
        return "PosTransactionRecordCardBlanceItem(id=" + this.getId() + ", personId=" + this.getPersonId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", deptName=" + this.getDeptName() + ", cardNo=" + this.getCardNo() + ", sysCardNo=" + this.getSysCardNo() + ", cardStatus=" + this.getCardStatus() + ", issueDate=" + this.getIssueDate() + ", balance=" + this.getBalance() + ", opTimeBegin=" + this.getOpTimeBegin() + ", opTimeEnd=" + this.getOpTimeEnd() + ", inDeptId=" + this.getInDeptId() + ", likeName=" + this.getLikeName() + ", userId=" + this.getUserId() + ")";
    }
}

