/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.annotation.Where;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="POS_TRANSACTIONCARD t ")
@Where(after="AND (t.HIDE_COLUMN = 15 or t.HIDE_COLUMN = 18 or t.HIDE_COLUMN = 19)")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600, operates={})
public class PosTransactionRecordBackCardItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID", equalTag="=")
    @GridColumn(checkbox=true, width="40", sort="na", show=false)
    private String id;
    @Column(name="t.PERSON_ID")
    @GridColumn(label="pos_transactionCard_personId", show=false)
    private String personId;
    @Column(name="t.PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="100", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}", i18n=true)
    private String personPin;
    @Column(name="t.PERSON_NAME")
    @GridColumn(label="pers_person_name", width="100", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @Column(name="t.PERSON_LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="80", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}", showExpression="#language!='zh_CN'")
    private String personLastName;
    @Column(name="t.DEPT_NAME")
    @GridColumn(label="pos_card_deptName", width="110")
    private String deptName;
    @Column(name="t.CARD", encryptConverter=true)
    @GridColumn(label="pos_card_card", width="85", encryptMode="${pers.cardNo.encryptMode}", encryptProp="${pers.cardNo.encryptProp}")
    private String card;
    @Column(name="t.SYS_CARD_NO")
    @GridColumn(label="pos_card_accountNum", width="85")
    private Integer sysCardNo;
    @Column(name="t.CARD_SERIAL")
    @GridColumn(label="pos_card_cardSerial", width="116")
    private Integer cardSerial;
    @Column(name="cast((t.MONEY + t.SUBMONEY) as decimal(18,2))")
    @GridColumn(label="pos_card_expend_back_money", width="105", format="0=0.0")
    private Double money;
    @Column(name="cast((t.BALANCE + t.SUBBALANCE) as decimal(18,2))")
    @GridColumn(label="pos_card_blance", width="78", format="0=0.0")
    private Double balance;
    @Column(name="t.CHECK_TIME")
    @GridColumn(label="pos_card_backTime", width="130")
    private Date checkTime;
    @Column(name="t.CREATER_NAME")
    @GridColumn(label="pos_card_changeOperator", width="130")
    private String changeOperator;
    @Condition(value="t.CHECK_TIME", equalTag=">=", toDate=true)
    private String opTimeBegin;
    @Condition(value="t.CHECK_TIME", equalTag="<=", toDate=true)
    private String opTimeEnd;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Column(name="t.HIDE_COLUMN")
    private Integer hideColumn;
    @Condition(value="(lower(t.PERSON_NAME) LIKE LOWER(''%{0}%'') OR lower(t.PERSON_LAST_NAME) LIKE LOWER(''%{0}%''))")
    private String likeName;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID = ''{0}'' )")
    private String userId;

    public PosTransactionRecordBackCardItem() {
    }

    public PosTransactionRecordBackCardItem(Boolean equals) {
        super(equals);
    }

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getCard() {
        return this.card;
    }

    public Integer getSysCardNo() {
        return this.sysCardNo;
    }

    public Integer getCardSerial() {
        return this.cardSerial;
    }

    public Double getMoney() {
        return this.money;
    }

    public Double getBalance() {
        return this.balance;
    }

    public Date getCheckTime() {
        return this.checkTime;
    }

    public String getChangeOperator() {
        return this.changeOperator;
    }

    public String getOpTimeBegin() {
        return this.opTimeBegin;
    }

    public String getOpTimeEnd() {
        return this.opTimeEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public Integer getHideColumn() {
        return this.hideColumn;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getUserId() {
        return this.userId;
    }

    public PosTransactionRecordBackCardItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosTransactionRecordBackCardItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PosTransactionRecordBackCardItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosTransactionRecordBackCardItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosTransactionRecordBackCardItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PosTransactionRecordBackCardItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PosTransactionRecordBackCardItem setCard(String card) {
        this.card = card;
        return this;
    }

    public PosTransactionRecordBackCardItem setSysCardNo(Integer sysCardNo) {
        this.sysCardNo = sysCardNo;
        return this;
    }

    public PosTransactionRecordBackCardItem setCardSerial(Integer cardSerial) {
        this.cardSerial = cardSerial;
        return this;
    }

    public PosTransactionRecordBackCardItem setMoney(Double money) {
        this.money = money;
        return this;
    }

    public PosTransactionRecordBackCardItem setBalance(Double balance) {
        this.balance = balance;
        return this;
    }

    public PosTransactionRecordBackCardItem setCheckTime(Date checkTime) {
        this.checkTime = checkTime;
        return this;
    }

    public PosTransactionRecordBackCardItem setChangeOperator(String changeOperator) {
        this.changeOperator = changeOperator;
        return this;
    }

    public PosTransactionRecordBackCardItem setOpTimeBegin(String opTimeBegin) {
        this.opTimeBegin = opTimeBegin;
        return this;
    }

    public PosTransactionRecordBackCardItem setOpTimeEnd(String opTimeEnd) {
        this.opTimeEnd = opTimeEnd;
        return this;
    }

    public PosTransactionRecordBackCardItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosTransactionRecordBackCardItem setHideColumn(Integer hideColumn) {
        this.hideColumn = hideColumn;
        return this;
    }

    public PosTransactionRecordBackCardItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PosTransactionRecordBackCardItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String toString() {
        return "PosTransactionRecordBackCardItem(id=" + this.getId() + ", personId=" + this.getPersonId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", deptName=" + this.getDeptName() + ", card=" + this.getCard() + ", sysCardNo=" + this.getSysCardNo() + ", cardSerial=" + this.getCardSerial() + ", money=" + this.getMoney() + ", balance=" + this.getBalance() + ", checkTime=" + this.getCheckTime() + ", changeOperator=" + this.getChangeOperator() + ", opTimeBegin=" + this.getOpTimeBegin() + ", opTimeEnd=" + this.getOpTimeEnd() + ", inDeptId=" + this.getInDeptId() + ", hideColumn=" + this.getHideColumn() + ", likeName=" + this.getLikeName() + ", userId=" + this.getUserId() + ")";
    }
}

