/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.UUID;

@From(after="POS_TRANSACTION T")
@GroupBy(after=" T.HALLING_ID")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosDiningHallConsumeItem
extends BaseItem
implements Comparable {
    @GridColumn(show=false)
    private String id;
    @Column(name="t.HALLING_ID")
    @GridColumn(label="pos_diningHall_name", width="70", show=false)
    private String hallingId;
    @Condition(value="t.HALLING_NAME", equalTag="like")
    @GridColumn(label="pos_diningHall_name", width="110", sort="na", i18n=true)
    private String hallingName;
    @Column(name="(sum(case when t.type_name = 6  then 1 else 0 end))")
    @GridColumn(label="pos_countTable_conTimes", width="120")
    private Integer conTimes;
    @Column(name="cast(sum(case when t.type_name = 6  then t.money + t.subMoney  else 0 end) as decimal(18,2))")
    @GridColumn(label="pos_countTable_consumTotal", width="120", format="0=0.0")
    private Double consumtotal;
    @Column(name="(sum(case when t.type_name = 10 then 1 else 0 end))")
    @GridColumn(label="pos_countTable_orderTimes", width="105")
    private Integer ordertimes;
    @Column(name="(sum(case when t.type_name = 9  then 1 else 0 end))")
    @GridColumn(label="pos_countTable_errorTimes", width="110")
    private Integer errortimes;
    @Column(name="cast(sum(case when t.type_name = 9  then t.money + t.subMoney else 0 end) as decimal(18,2))")
    @GridColumn(label="pos_countTable_errorTotal", width="140", format="0=0.0")
    private Double errortotal;
    @Column(name="(sum(case when t.type_name = 8  then 1 else 0 end))")
    @GridColumn(label="pos_countTable_suppleTimes", width="140")
    private Integer suppletimes;
    @Column(name="cast(sum(case when t.type_name = 8  then t.money + t.subMoney else 0 end) as decimal(18,2))")
    @GridColumn(label="pos_countTable_suppleTotal", width="160", format="0=0.0")
    private Double suppletotal;
    @Column(name="(sum(case when t.type_name = 11  then 1 else 0 end))")
    @GridColumn(label="pos_countTable_accountTimes", width="115")
    private Integer accounttimes;
    @Column(name="cast(sum(case when t.type_name = 11  then t.money + t.subMoney else 0 end) as decimal(18,2))")
    @GridColumn(label="pos_countTable_accountTotal", width="105", format="0=0.0")
    private Double accountTotal;
    @Column(name="(sum(case when t.type_name = 6 then 1 else 0 end)-sum(case when t.type_name = 9 then 1 else 0 end))")
    @GridColumn(label="pos_countTable_actualTimes", width="120")
    private Integer actualtimes;
    @Column(name="cast((sum(case when t.type_name = 6  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 9  then t.money + t.subMoney else 0 end)) as decimal(18,2))")
    @GridColumn(label="pos_countTable_equipTotal", width="130", format="0=0.0")
    private Double equipTotal;
    @Column(name="cast((sum(case when t.type_name = 6  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 9  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 8  then t.money + t.subMoney else 0 end)) as decimal(18,2))")
    @GridColumn(label="pos_countTable_sysTotal", width="150", format="0=0.0")
    private Double sysTotal;
    @Column(name="cast((sum(case when t.type_name = 6  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 9  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 11  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 8  then t.money + t.subMoney else 0 end)) as decimal(18,2))")
    @GridColumn(label="pos_countTable_containAccTotal", width="150", format="0=0.0")
    private Double containAccTotal;
    @GridColumn(label="pos_countTable_conTimeStr", minWidth="160", width="170", sort="na")
    private String posTime;
    @Condition(value="t.POS_TIME", equalTag=">=", toDate=true)
    private String opTimeBegin;
    @Condition(value="t.POS_TIME", equalTag="<=", toDate=true)
    private String opTimeEnd;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID = ''{0}'' )")
    private String userId;

    public PosDiningHallConsumeItem() {
        this.id = UUID.randomUUID().toString();
    }

    public PosDiningHallConsumeItem(Boolean equals) {
        super(equals);
    }

    public PosDiningHallConsumeItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PosDiningHallConsumeItem(String id, String hallingName, Integer conTimes, Double consumtotal, Integer ordertimes, Integer errortimes, Double errortotal, Integer suppletimes, Double suppletotal, Integer accounttimes, Double accountTotal, Integer actualtimes, Double equipTotal, Double sysTotal, Double containAccTotal) {
        this.id = id;
        this.hallingName = hallingName;
        this.conTimes = conTimes;
        this.consumtotal = consumtotal;
        this.ordertimes = ordertimes;
        this.errortimes = errortimes;
        this.errortotal = errortotal;
        this.suppletimes = suppletimes;
        this.suppletotal = suppletotal;
        this.accounttimes = accounttimes;
        this.accountTotal = accountTotal;
        this.actualtimes = actualtimes;
        this.equipTotal = equipTotal;
        this.sysTotal = sysTotal;
        this.containAccTotal = containAccTotal;
    }

    public int compareTo(Object o) {
        PosDiningHallConsumeItem diningHallItem = (PosDiningHallConsumeItem)o;
        String hallingName = diningHallItem.getHallingName();
        return this.hallingName.compareTo(hallingName);
    }

    public String getId() {
        return this.id;
    }

    public String getHallingId() {
        return this.hallingId;
    }

    public String getHallingName() {
        return this.hallingName;
    }

    public Integer getConTimes() {
        return this.conTimes;
    }

    public Double getConsumtotal() {
        return this.consumtotal;
    }

    public Integer getOrdertimes() {
        return this.ordertimes;
    }

    public Integer getErrortimes() {
        return this.errortimes;
    }

    public Double getErrortotal() {
        return this.errortotal;
    }

    public Integer getSuppletimes() {
        return this.suppletimes;
    }

    public Double getSuppletotal() {
        return this.suppletotal;
    }

    public Integer getAccounttimes() {
        return this.accounttimes;
    }

    public Double getAccountTotal() {
        return this.accountTotal;
    }

    public Integer getActualtimes() {
        return this.actualtimes;
    }

    public Double getEquipTotal() {
        return this.equipTotal;
    }

    public Double getSysTotal() {
        return this.sysTotal;
    }

    public Double getContainAccTotal() {
        return this.containAccTotal;
    }

    public String getPosTime() {
        return this.posTime;
    }

    public String getOpTimeBegin() {
        return this.opTimeBegin;
    }

    public String getOpTimeEnd() {
        return this.opTimeEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getUserId() {
        return this.userId;
    }

    public PosDiningHallConsumeItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosDiningHallConsumeItem setHallingId(String hallingId) {
        this.hallingId = hallingId;
        return this;
    }

    public PosDiningHallConsumeItem setHallingName(String hallingName) {
        this.hallingName = hallingName;
        return this;
    }

    public PosDiningHallConsumeItem setConTimes(Integer conTimes) {
        this.conTimes = conTimes;
        return this;
    }

    public PosDiningHallConsumeItem setConsumtotal(Double consumtotal) {
        this.consumtotal = consumtotal;
        return this;
    }

    public PosDiningHallConsumeItem setOrdertimes(Integer ordertimes) {
        this.ordertimes = ordertimes;
        return this;
    }

    public PosDiningHallConsumeItem setErrortimes(Integer errortimes) {
        this.errortimes = errortimes;
        return this;
    }

    public PosDiningHallConsumeItem setErrortotal(Double errortotal) {
        this.errortotal = errortotal;
        return this;
    }

    public PosDiningHallConsumeItem setSuppletimes(Integer suppletimes) {
        this.suppletimes = suppletimes;
        return this;
    }

    public PosDiningHallConsumeItem setSuppletotal(Double suppletotal) {
        this.suppletotal = suppletotal;
        return this;
    }

    public PosDiningHallConsumeItem setAccounttimes(Integer accounttimes) {
        this.accounttimes = accounttimes;
        return this;
    }

    public PosDiningHallConsumeItem setAccountTotal(Double accountTotal) {
        this.accountTotal = accountTotal;
        return this;
    }

    public PosDiningHallConsumeItem setActualtimes(Integer actualtimes) {
        this.actualtimes = actualtimes;
        return this;
    }

    public PosDiningHallConsumeItem setEquipTotal(Double equipTotal) {
        this.equipTotal = equipTotal;
        return this;
    }

    public PosDiningHallConsumeItem setSysTotal(Double sysTotal) {
        this.sysTotal = sysTotal;
        return this;
    }

    public PosDiningHallConsumeItem setContainAccTotal(Double containAccTotal) {
        this.containAccTotal = containAccTotal;
        return this;
    }

    public PosDiningHallConsumeItem setPosTime(String posTime) {
        this.posTime = posTime;
        return this;
    }

    public PosDiningHallConsumeItem setOpTimeBegin(String opTimeBegin) {
        this.opTimeBegin = opTimeBegin;
        return this;
    }

    public PosDiningHallConsumeItem setOpTimeEnd(String opTimeEnd) {
        this.opTimeEnd = opTimeEnd;
        return this;
    }

    public PosDiningHallConsumeItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosDiningHallConsumeItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String toString() {
        return "PosDiningHallConsumeItem(id=" + this.getId() + ", hallingId=" + this.getHallingId() + ", hallingName=" + this.getHallingName() + ", conTimes=" + this.getConTimes() + ", consumtotal=" + this.getConsumtotal() + ", ordertimes=" + this.getOrdertimes() + ", errortimes=" + this.getErrortimes() + ", errortotal=" + this.getErrortotal() + ", suppletimes=" + this.getSuppletimes() + ", suppletotal=" + this.getSuppletotal() + ", accounttimes=" + this.getAccounttimes() + ", accountTotal=" + this.getAccountTotal() + ", actualtimes=" + this.getActualtimes() + ", equipTotal=" + this.getEquipTotal() + ", sysTotal=" + this.getSysTotal() + ", containAccTotal=" + this.getContainAccTotal() + ", posTime=" + this.getPosTime() + ", opTimeBegin=" + this.getOpTimeBegin() + ", opTimeEnd=" + this.getOpTimeEnd() + ", inDeptId=" + this.getInDeptId() + ", userId=" + this.getUserId() + ")";
    }
}

