/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.UUID;

@From(after="POS_TRANSACTION t ")
@GroupBy(after=" t.DEV_SN")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosDeviceConsumeItem
extends BaseItem {
    @GridColumn(show=false)
    private String id;
    @Condition(value="t.DEV_ALIAS", equalTag="like")
    @GridColumn(label="common_dev_name", width="90", i18n=true)
    private String devAlias;
    @Column(name="t.DEV_SN")
    @GridColumn(label="common_dev_sn", width="130", i18n=true)
    private String devSn;
    @Column(name="(sum(case when t.type_name = 6  then 1 else 0 end))")
    @GridColumn(label="pos_countTable_conTimes", width="120")
    private Integer conTimes;
    @Column(name="cast(sum(case when t.type_name = 6  then t.money + t.subMoney  else 0 end) as decimal(18,2))")
    @GridColumn(label="pos_countTable_consumTotal", width="120", format="0=0.0")
    private Double consumtotal;
    @Column(name="(sum(case when t.type_name = 10 then 1 else 0 end))")
    @GridColumn(label="pos_countTable_orderTimes", width="100")
    private Integer ordertimes;
    @Column(name="(sum(case when t.type_name = 9  then 1 else 0 end))")
    @GridColumn(label="pos_countTable_errorTimes", width="170")
    private Integer errortimes;
    @Column(name="cast(sum(case when t.type_name = 9  then t.money + t.subMoney else 0 end) as decimal(18,2))")
    @GridColumn(label="pos_countTable_errorTotal", width="80", format="0=0.0")
    private Double errortotal;
    @Column(name="(sum(case when t.type_name = 8  then 1 else 0 end))")
    @GridColumn(label="pos_countTable_suppleTimes", width="70")
    private Integer suppletimes;
    @Column(name="cast(sum(case when t.type_name = 8  then t.money + t.subMoney else 0 end) as decimal(18,2))")
    @GridColumn(label="pos_countTable_suppleTotal", width="80", format="0=0.0")
    private Double suppletotal;
    @Column(name="(sum(case when t.type_name = 11  then 1 else 0 end))")
    @GridColumn(label="pos_countTable_accountTimes", width="70")
    private Integer accounttimes;
    @Column(name="cast(sum(case when t.type_name = 11  then t.money + t.subMoney else 0 end) as decimal(18,2))")
    @GridColumn(label="pos_countTable_accountTotal", width="80", format="0=0.0")
    private Double accountTotal;
    @Column(name="(sum(case when t.type_name = 6 then 1 else 0 end)-sum(case when t.type_name = 9 then 1 else 0 end))")
    @GridColumn(label="pos_countTable_actualTimes", width="120")
    private Integer actualtimes;
    @Column(name="cast((sum(case when t.type_name = 6  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 9  then t.money + t.subMoney else 0 end)) as decimal(18,2))")
    @GridColumn(label="pos_countTable_equipTotal", width="130", format="0=0.0")
    private Double equipTotal;
    @Column(name="cast((sum(case when t.type_name = 6  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 9  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 8  then t.money + t.subMoney else 0 end)) as decimal(18,2))")
    @GridColumn(label="pos_countTable_sysTotal", width="150", format="0=0.0")
    private Double sysTotal;
    @Column(name="cast((sum(case when t.type_name = 6  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 9  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 11  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 8  then t.money + t.subMoney else 0 end)) as decimal(18,2))")
    @GridColumn(label="pos_countTable_containAccTotal", width="150", format="0=0.0")
    private Double containAccTotal;
    @GridColumn(label="pos_countTable_conTimeStr", minWidth="160", width="170", sort="na")
    private String posTime;
    @Condition(value="t.POS_TIME", equalTag=">=", toDate=true)
    private String opTimeBegin;
    @Condition(value="t.POS_TIME", equalTag="<=", toDate=true)
    private String opTimeEnd;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID = ''{0}'' )")
    private String userId;

    public PosDeviceConsumeItem() {
        this.id = UUID.randomUUID().toString();
    }

    public PosDeviceConsumeItem(Boolean equals) {
        super(equals);
    }

    public PosDeviceConsumeItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PosDeviceConsumeItem(Boolean equals, String id, String devAlias, String devSn, Integer conTimes, Double consumtotal, Integer ordertimes, Integer errortimes, Double errortotal, Integer suppletimes, Double suppletotal, Integer accounttimes, Double accountTotal, Integer actualtimes, Double equipTotal, Double sysTotal, Double containAccTotal) {
        super(equals);
        this.id = id;
        this.devAlias = devAlias;
        this.devSn = devSn;
        this.conTimes = conTimes;
        this.consumtotal = consumtotal;
        this.ordertimes = ordertimes;
        this.errortimes = errortimes;
        this.errortotal = errortotal;
        this.suppletimes = suppletimes;
        this.suppletotal = suppletotal;
        this.accounttimes = accounttimes;
        this.accountTotal = accountTotal;
        this.actualtimes = actualtimes;
        this.equipTotal = equipTotal;
        this.sysTotal = sysTotal;
        this.containAccTotal = containAccTotal;
    }

    public String getId() {
        return this.id;
    }

    public String getDevAlias() {
        return this.devAlias;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public Integer getConTimes() {
        return this.conTimes;
    }

    public Double getConsumtotal() {
        return this.consumtotal;
    }

    public Integer getOrdertimes() {
        return this.ordertimes;
    }

    public Integer getErrortimes() {
        return this.errortimes;
    }

    public Double getErrortotal() {
        return this.errortotal;
    }

    public Integer getSuppletimes() {
        return this.suppletimes;
    }

    public Double getSuppletotal() {
        return this.suppletotal;
    }

    public Integer getAccounttimes() {
        return this.accounttimes;
    }

    public Double getAccountTotal() {
        return this.accountTotal;
    }

    public Integer getActualtimes() {
        return this.actualtimes;
    }

    public Double getEquipTotal() {
        return this.equipTotal;
    }

    public Double getSysTotal() {
        return this.sysTotal;
    }

    public Double getContainAccTotal() {
        return this.containAccTotal;
    }

    public String getPosTime() {
        return this.posTime;
    }

    public String getOpTimeBegin() {
        return this.opTimeBegin;
    }

    public String getOpTimeEnd() {
        return this.opTimeEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getUserId() {
        return this.userId;
    }

    public PosDeviceConsumeItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosDeviceConsumeItem setDevAlias(String devAlias) {
        this.devAlias = devAlias;
        return this;
    }

    public PosDeviceConsumeItem setDevSn(String devSn) {
        this.devSn = devSn;
        return this;
    }

    public PosDeviceConsumeItem setConTimes(Integer conTimes) {
        this.conTimes = conTimes;
        return this;
    }

    public PosDeviceConsumeItem setConsumtotal(Double consumtotal) {
        this.consumtotal = consumtotal;
        return this;
    }

    public PosDeviceConsumeItem setOrdertimes(Integer ordertimes) {
        this.ordertimes = ordertimes;
        return this;
    }

    public PosDeviceConsumeItem setErrortimes(Integer errortimes) {
        this.errortimes = errortimes;
        return this;
    }

    public PosDeviceConsumeItem setErrortotal(Double errortotal) {
        this.errortotal = errortotal;
        return this;
    }

    public PosDeviceConsumeItem setSuppletimes(Integer suppletimes) {
        this.suppletimes = suppletimes;
        return this;
    }

    public PosDeviceConsumeItem setSuppletotal(Double suppletotal) {
        this.suppletotal = suppletotal;
        return this;
    }

    public PosDeviceConsumeItem setAccounttimes(Integer accounttimes) {
        this.accounttimes = accounttimes;
        return this;
    }

    public PosDeviceConsumeItem setAccountTotal(Double accountTotal) {
        this.accountTotal = accountTotal;
        return this;
    }

    public PosDeviceConsumeItem setActualtimes(Integer actualtimes) {
        this.actualtimes = actualtimes;
        return this;
    }

    public PosDeviceConsumeItem setEquipTotal(Double equipTotal) {
        this.equipTotal = equipTotal;
        return this;
    }

    public PosDeviceConsumeItem setSysTotal(Double sysTotal) {
        this.sysTotal = sysTotal;
        return this;
    }

    public PosDeviceConsumeItem setContainAccTotal(Double containAccTotal) {
        this.containAccTotal = containAccTotal;
        return this;
    }

    public PosDeviceConsumeItem setPosTime(String posTime) {
        this.posTime = posTime;
        return this;
    }

    public PosDeviceConsumeItem setOpTimeBegin(String opTimeBegin) {
        this.opTimeBegin = opTimeBegin;
        return this;
    }

    public PosDeviceConsumeItem setOpTimeEnd(String opTimeEnd) {
        this.opTimeEnd = opTimeEnd;
        return this;
    }

    public PosDeviceConsumeItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosDeviceConsumeItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String toString() {
        return "PosDeviceConsumeItem(id=" + this.getId() + ", devAlias=" + this.getDevAlias() + ", devSn=" + this.getDevSn() + ", conTimes=" + this.getConTimes() + ", consumtotal=" + this.getConsumtotal() + ", ordertimes=" + this.getOrdertimes() + ", errortimes=" + this.getErrortimes() + ", errortotal=" + this.getErrortotal() + ", suppletimes=" + this.getSuppletimes() + ", suppletotal=" + this.getSuppletotal() + ", accounttimes=" + this.getAccounttimes() + ", accountTotal=" + this.getAccountTotal() + ", actualtimes=" + this.getActualtimes() + ", equipTotal=" + this.getEquipTotal() + ", sysTotal=" + this.getSysTotal() + ", containAccTotal=" + this.getContainAccTotal() + ", posTime=" + this.getPosTime() + ", opTimeBegin=" + this.getOpTimeBegin() + ", opTimeEnd=" + this.getOpTimeEnd() + ", inDeptId=" + this.getInDeptId() + ", userId=" + this.getUserId() + ")";
    }
}

