/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.UUID;

@From(after="POS_TRANSACTION T")
@GroupBy(after=" T.DEPT_ID, T.DEPT_NAME")
@OrderBy(after="T.DEPT_ID")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosDeptConsumeItem
extends BaseItem {
    @GridColumn(show=false)
    private String id;
    @Column(name="t.DEPT_ID")
    @GridColumn(label="pos_transaction_deptId", show=false)
    private String deptId;
    @Column(name="t.DEPT_NAME")
    @GridColumn(label="pos_card_deptName", width="110", i18n=true)
    private String deptName;
    @Column(name="(sum(case when t.type_name = 6  then 1 else 0 end))")
    @GridColumn(label="pos_countTable_conTimes", width="120")
    private Integer conTimes;
    @Column(name="cast(sum(case when t.type_name = 6  then t.money + t.subMoney  else 0 end) as decimal(18,2))")
    @GridColumn(label="pos_countTable_consumTotal", width="115", format="0=0.0")
    private Double consumtotal;
    @Column(name="(sum(case when t.type_name = 10 then 1 else 0 end))")
    @GridColumn(label="pos_countTable_orderTimes", width="100")
    private Integer ordertimes;
    @Column(name="(sum(case when t.type_name = 9  then 1 else 0 end))")
    @GridColumn(label="pos_countTable_errorTimes", width="170")
    private Integer errortimes;
    @Column(name="cast(sum(case when t.type_name = 9  then t.money + t.subMoney else 0 end) as decimal(18,2))")
    @GridColumn(label="pos_countTable_errorTotal", width="135", format="0=0.0")
    private Double errortotal;
    @Column(name="(sum(case when t.type_name = 8  then 1 else 0 end))")
    @GridColumn(label="pos_countTable_suppleTimes", width="130")
    private Integer suppletimes;
    @Column(name="cast(sum(case when t.type_name = 8  then t.money + t.subMoney else 0 end) as decimal(18,2))")
    @GridColumn(label="pos_countTable_suppleTotal", width="160", format="0=0.0")
    private Double suppletotal;
    @Column(name="(sum(case when t.type_name = 11  then 1 else 0 end))")
    @GridColumn(label="pos_countTable_accountTimes", width="70")
    private Integer accounttimes;
    @Column(name="cast(sum(case when t.type_name = 11  then t.money + t.subMoney else 0 end) as decimal(18,2))")
    @GridColumn(label="pos_countTable_accountTotal", width="80", format="0=0.0")
    private Double accountTotal;
    @Column(name="(sum(case when t.type_name = 6 then 1 else 0 end)-sum(case when t.type_name = 9 then 1 else 0 end))")
    @GridColumn(label="pos_countTable_actualTimes", width="120")
    private Integer actualtimes;
    @Column(name="cast((sum(case when t.type_name = 6  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 9  then t.money + t.subMoney else 0 end)) as decimal(18,2))")
    @GridColumn(label="pos_countTable_equipTotal", width="130", format="0=0.0")
    private Double equipTotal;
    @Column(name="cast((sum(case when t.type_name = 6  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 9  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 8  then t.money + t.subMoney else 0 end)) as decimal(18,2))")
    @GridColumn(label="pos_countTable_sysTotal", width="150", format="0=0.0")
    private Double sysTotal;
    @Column(name="cast((sum(case when t.type_name = 6  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 9  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 11  then t.money + t.subMoney else 0 end)+sum(case when t.type_name = 8  then t.money + t.subMoney else 0 end)) as decimal(18,2))")
    @GridColumn(label="pos_countTable_containAccTotal", width="150", format="0=0.0")
    private Double containAccTotal;
    @GridColumn(label="pos_countTable_conTimeStr", minWidth="160", width="170", sort="na")
    private String posTime;
    @Condition(value="t.POS_TIME", equalTag=">=", toDate=true)
    private String opTimeBegin;
    @Condition(value="t.POS_TIME", equalTag="<=", toDate=true)
    private String opTimeEnd;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID = ''{0}'' )")
    private String userId;

    public PosDeptConsumeItem() {
        this.id = UUID.randomUUID().toString();
    }

    public PosDeptConsumeItem(Boolean equals) {
        super(equals);
    }

    public PosDeptConsumeItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PosDeptConsumeItem(Boolean equals, String id, String deptName, Integer conTimes, Double consumtotal, Integer ordertimes, Integer errortimes, Double errortotal, Integer suppletimes, Double suppletotal, Integer accounttimes, Double accountTotal, Integer actualtimes, Double equipTotal, Double sysTotal, Double containAccTotal) {
        super(equals);
        this.id = id;
        this.deptName = deptName;
        this.conTimes = conTimes;
        this.consumtotal = consumtotal;
        this.ordertimes = ordertimes;
        this.errortimes = errortimes;
        this.errortotal = errortotal;
        this.suppletimes = suppletimes;
        this.suppletotal = suppletotal;
        this.accounttimes = accounttimes;
        this.accountTotal = accountTotal;
        this.actualtimes = actualtimes;
        this.equipTotal = equipTotal;
        this.sysTotal = sysTotal;
        this.containAccTotal = containAccTotal;
    }

    public String getId() {
        return this.id;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public Integer getConTimes() {
        return this.conTimes;
    }

    public Double getConsumtotal() {
        return this.consumtotal;
    }

    public Integer getOrdertimes() {
        return this.ordertimes;
    }

    public Integer getErrortimes() {
        return this.errortimes;
    }

    public Double getErrortotal() {
        return this.errortotal;
    }

    public Integer getSuppletimes() {
        return this.suppletimes;
    }

    public Double getSuppletotal() {
        return this.suppletotal;
    }

    public Integer getAccounttimes() {
        return this.accounttimes;
    }

    public Double getAccountTotal() {
        return this.accountTotal;
    }

    public Integer getActualtimes() {
        return this.actualtimes;
    }

    public Double getEquipTotal() {
        return this.equipTotal;
    }

    public Double getSysTotal() {
        return this.sysTotal;
    }

    public Double getContainAccTotal() {
        return this.containAccTotal;
    }

    public String getPosTime() {
        return this.posTime;
    }

    public String getOpTimeBegin() {
        return this.opTimeBegin;
    }

    public String getOpTimeEnd() {
        return this.opTimeEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getUserId() {
        return this.userId;
    }

    public PosDeptConsumeItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosDeptConsumeItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosDeptConsumeItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PosDeptConsumeItem setConTimes(Integer conTimes) {
        this.conTimes = conTimes;
        return this;
    }

    public PosDeptConsumeItem setConsumtotal(Double consumtotal) {
        this.consumtotal = consumtotal;
        return this;
    }

    public PosDeptConsumeItem setOrdertimes(Integer ordertimes) {
        this.ordertimes = ordertimes;
        return this;
    }

    public PosDeptConsumeItem setErrortimes(Integer errortimes) {
        this.errortimes = errortimes;
        return this;
    }

    public PosDeptConsumeItem setErrortotal(Double errortotal) {
        this.errortotal = errortotal;
        return this;
    }

    public PosDeptConsumeItem setSuppletimes(Integer suppletimes) {
        this.suppletimes = suppletimes;
        return this;
    }

    public PosDeptConsumeItem setSuppletotal(Double suppletotal) {
        this.suppletotal = suppletotal;
        return this;
    }

    public PosDeptConsumeItem setAccounttimes(Integer accounttimes) {
        this.accounttimes = accounttimes;
        return this;
    }

    public PosDeptConsumeItem setAccountTotal(Double accountTotal) {
        this.accountTotal = accountTotal;
        return this;
    }

    public PosDeptConsumeItem setActualtimes(Integer actualtimes) {
        this.actualtimes = actualtimes;
        return this;
    }

    public PosDeptConsumeItem setEquipTotal(Double equipTotal) {
        this.equipTotal = equipTotal;
        return this;
    }

    public PosDeptConsumeItem setSysTotal(Double sysTotal) {
        this.sysTotal = sysTotal;
        return this;
    }

    public PosDeptConsumeItem setContainAccTotal(Double containAccTotal) {
        this.containAccTotal = containAccTotal;
        return this;
    }

    public PosDeptConsumeItem setPosTime(String posTime) {
        this.posTime = posTime;
        return this;
    }

    public PosDeptConsumeItem setOpTimeBegin(String opTimeBegin) {
        this.opTimeBegin = opTimeBegin;
        return this;
    }

    public PosDeptConsumeItem setOpTimeEnd(String opTimeEnd) {
        this.opTimeEnd = opTimeEnd;
        return this;
    }

    public PosDeptConsumeItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosDeptConsumeItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String toString() {
        return "PosDeptConsumeItem(id=" + this.getId() + ", deptId=" + this.getDeptId() + ", deptName=" + this.getDeptName() + ", conTimes=" + this.getConTimes() + ", consumtotal=" + this.getConsumtotal() + ", ordertimes=" + this.getOrdertimes() + ", errortimes=" + this.getErrortimes() + ", errortotal=" + this.getErrortotal() + ", suppletimes=" + this.getSuppletimes() + ", suppletotal=" + this.getSuppletotal() + ", accounttimes=" + this.getAccounttimes() + ", accountTotal=" + this.getAccountTotal() + ", actualtimes=" + this.getActualtimes() + ", equipTotal=" + this.getEquipTotal() + ", sysTotal=" + this.getSysTotal() + ", containAccTotal=" + this.getContainAccTotal() + ", posTime=" + this.getPosTime() + ", opTimeBegin=" + this.getOpTimeBegin() + ", opTimeEnd=" + this.getOpTimeEnd() + ", inDeptId=" + this.getInDeptId() + ", userId=" + this.getUserId() + ")";
    }
}

